/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.IFluidHandlerInternal;
import zmaster587.libVulpes.util.ZUtils;

public abstract class TileMultiblockMachine
extends TileMultiPowerConsumer {
    private List<ItemStack> outputItemStacks = null;
    private List<FluidStack> outputFluidStacks;
    boolean smartInventoryUpgrade = true;
    boolean invCheckFlag = false;

    public List<ItemStack> getOutputs() {
        return this.outputItemStacks;
    }

    public void setOutputs(List<ItemStack> stack) {
        this.outputItemStacks = stack;
    }

    public void setOutputFluids(List<FluidStack> stack) {
        this.outputFluidStacks = stack;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        nbt.func_74757_a("built", this.canRender);
        nbt.func_74757_a("hadPowerLastTick", this.hadPowerLastTick);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = this.func_189515_b(new NBTTagCompound());
        nbt.func_74757_a("built", this.canRender);
        nbt.func_74757_a("hadPowerLastTick", this.hadPowerLastTick);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.canRender = nbt.func_74767_n("built");
        this.hadPowerLastTick = nbt.func_74767_n("hadPowerLastTick");
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("built");
        this.hadPowerLastTick = nbt.func_74767_n("hadPowerLastTick");
        this.func_145839_a(nbt);
    }

    public void registerRecipes() {
    }

    @Override
    public void func_73660_a() {
        if (this.timeAlive == 0) {
            SoundEvent str;
            if (!this.field_145850_b.field_72995_K) {
                if (this.isComplete()) {
                    this.canRender = this.completeStructure = this.completeStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
                }
            } else if (this.field_145850_b.field_72995_K && (str = this.getSound()) != null) {
                this.playMachineSound(str);
            }
            this.timeAlive = 1;
        }
        if (!this.isRunning() && this.field_145850_b.func_82737_E() % 1000L == 0L) {
            this.onInventoryUpdated();
        }
        if (this.isRunning()) {
            if (this.hasEnergy(this.powerPerTick) || this.field_145850_b.field_72995_K && this.hadPowerLastTick) {
                this.onRunningPoweredTick();
                if (!this.field_145850_b.field_72995_K) {
                    if (!this.hadPowerLastTick) {
                        this.hadPowerLastTick = true;
                        this.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                    }
                    this.useEnergy(this.powerPerTick);
                }
            } else if (!this.field_145850_b.field_72995_K && this.hadPowerLastTick) {
                this.hadPowerLastTick = false;
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    @Override
    public void setMachineEnabled(boolean enabled) {
        super.setMachineEnabled(enabled);
        this.onInventoryUpdated();
    }

    @Override
    public void resetCache() {
        super.resetCache();
        this.batteries.clear();
    }

    @Override
    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, IBlockState state) {
        this.outputItemStacks = null;
        this.outputFluidStacks = null;
        super.deconstructMultiBlock(world, destroyedPos, blockBroken, state);
    }

    @Override
    protected void processComplete() {
        this.completionTime = 0;
        this.currentTime = 0;
        if (!this.field_145850_b.field_72995_K) {
            this.dumpOutputToInventory();
        }
        this.outputItemStacks = null;
        this.outputFluidStacks = null;
        this.onInventoryUpdated();
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    protected void dumpOutputToInventory() {
        int totalItems = 0;
        for (IInventory outInventory : this.getItemOutPorts()) {
            for (int i = totalItems; i < this.outputItemStacks.size(); ++i) {
                ItemStack stack = outInventory.func_70301_a(this.smartInventoryUpgrade ? outInventory.func_70302_i_() - i - 1 : i);
                if (stack == ItemStack.field_190927_a || stack.func_77973_b() == Items.field_190931_a) {
                    outInventory.func_70299_a(this.smartInventoryUpgrade ? outInventory.func_70302_i_() - i - 1 : i, this.outputItemStacks.get(i));
                    outInventory.func_70296_d();
                    ++totalItems;
                    continue;
                }
                if (!stack.func_77969_a(this.outputItemStacks.get(i)) || stack.func_190916_E() + this.outputItemStacks.get(i).func_190916_E() > outInventory.func_70297_j_() || stack.func_190916_E() + this.outputItemStacks.get(i).func_190916_E() > stack.func_77976_d()) continue;
                outInventory.func_70301_a(this.smartInventoryUpgrade ? outInventory.func_70302_i_() - i - 1 : i).func_190920_e(outInventory.func_70301_a(this.smartInventoryUpgrade ? outInventory.func_70302_i_() - i - 1 : i).func_190916_E() + this.outputItemStacks.get(i).func_190916_E());
                outInventory.func_70296_d();
                ++totalItems;
            }
        }
        for (int i = 0; i < this.outputFluidStacks.size(); ++i) {
            ((IFluidHandlerInternal)this.fluidOutPorts.get(i)).fillInternal(this.outputFluidStacks.get(i), true);
        }
    }

    protected IRecipe getRecipe(List<IRecipe> set) {
        for (IRecipe recipe : set) {
            if (!this.canProcessRecipe(recipe)) continue;
            return recipe;
        }
        return null;
    }

    protected List<ItemStack> getItemOutputs(IRecipe recipe) {
        return recipe.getOutput();
    }

    protected List<FluidStack> getFluidOutputs(IRecipe recipe) {
        return recipe.getFluidOutputs();
    }

    public void consumeItems(IRecipe recipe) {
        List<List<ItemStack>> ingredients = recipe.getIngredients();
        block0: for (int ingredientNum = 0; ingredientNum < ingredients.size(); ++ingredientNum) {
            List<ItemStack> ingredient = ingredients.get(ingredientNum);
            for (IInventory hatch : this.getItemInPorts()) {
                for (int i = 0; i < hatch.func_70302_i_(); ++i) {
                    ItemStack stackInSlot = hatch.func_70301_a(i);
                    for (ItemStack stack : ingredient) {
                        if (stackInSlot == null || stackInSlot.func_190916_E() < stack.func_190916_E() || !stackInSlot.func_77969_a(stack) && (stack.func_77952_i() != Short.MAX_VALUE || stackInSlot.func_77973_b() != stack.func_77973_b())) continue;
                        hatch.func_70298_a(i, stack.func_190916_E());
                        hatch.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(((TileEntity)hatch).func_174877_v()), this.field_145850_b.func_180495_p(((TileEntity)hatch).func_174877_v()), 6);
                        continue block0;
                    }
                }
            }
        }
        int[] fluidInputCounter = new int[recipe.getFluidIngredients().size()];
        for (int i = 0; i < recipe.getFluidIngredients().size(); ++i) {
            fluidInputCounter[i] = recipe.getFluidIngredients().get((int)i).amount;
        }
        for (IFluidHandlerInternal fluidInput : this.fluidInPorts) {
            for (int i = 0; i < recipe.getFluidIngredients().size(); ++i) {
                FluidStack fluidStack = recipe.getFluidIngredients().get(i).copy();
                fluidStack.amount = fluidInputCounter[i];
                FluidStack drainedFluid = fluidInput.drainInternal(recipe.getFluidIngredients().get(i), true);
                if (drainedFluid == null) continue;
                int n = i;
                fluidInputCounter[n] = fluidInputCounter[n] - drainedFluid.amount;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean canProcessRecipe(IRecipe recipe) {
        int i;
        void var8_17;
        boolean itemCheck;
        block27: {
            List<ItemStack> outputItems;
            if (!this.isComplete() || this.invCheckFlag) {
                return false;
            }
            this.invCheckFlag = true;
            int reservedSpotSize = 0;
            if (recipe instanceof RecipesMachine.Recipe) {
                reservedSpotSize = ((RecipesMachine.Recipe)recipe).getRequiredEmptyOutputs();
            }
            itemCheck = (outputItems = this.getItemOutputs(recipe)).size() == 0;
            List<List<ItemStack>> ingredients = recipe.getIngredients();
            int mask = 0;
            block0: for (int ingredientNum = 0; ingredientNum < ingredients.size(); ++ingredientNum) {
                List<ItemStack> list = ingredients.get(ingredientNum);
                for (IInventory hatch : this.getItemInPorts()) {
                    for (int i2 = 0; i2 < hatch.func_70302_i_(); ++i2) {
                        ItemStack stackInSlot = hatch.func_70301_a(i2);
                        for (ItemStack stack : list) {
                            if (stackInSlot == ItemStack.field_190927_a || stackInSlot.func_190916_E() < stack.func_190916_E() || !stackInSlot.func_77969_a(stack) && (stack.func_77952_i() != Short.MAX_VALUE || stack.func_77973_b() != stackInSlot.func_77973_b())) continue;
                            mask = (short)(mask | 1 << ingredientNum);
                            continue block0;
                        }
                    }
                }
            }
            if (mask != (1 << ingredients.size()) - 1) {
                this.invCheckFlag = false;
                return false;
            }
            if (reservedSpotSize < 0) {
                for (IInventory iInventory : this.getItemOutPorts()) {
                    if (iInventory.func_70302_i_() - outputItems.size() < 0) continue;
                    for (int i3 = this.smartInventoryUpgrade ? iInventory.func_70302_i_() - outputItems.size() : 0; i3 < (this.smartInventoryUpgrade ? iInventory.func_70302_i_() : outputItems.size()); ++i3) {
                        ItemStack stack = iInventory.func_70301_a(i3);
                        if (this.smartInventoryUpgrade) {
                            int j;
                            ItemStack outputItem = outputItems.get(iInventory.func_70302_i_() - i3 - 1);
                            boolean allIngredFit = true;
                            for (int k = 0; k < outputItems.size() && i3 - k >= 0; ++k) {
                                ItemStack stack2 = iInventory.func_70301_a(iInventory.func_70302_i_() - k - 1);
                                ItemStack outputItem2 = outputItems.get(k);
                                boolean bl = allIngredFit = stack2.func_190926_b() || stack2.func_77969_a(outputItem2) && stack2.func_190916_E() + outputItem2.func_190916_E() <= iInventory.func_70297_j_() && stack2.func_190916_E() + outputItem2.func_190916_E() <= stack.func_77976_d();
                                if (!allIngredFit) break;
                            }
                            if (allIngredFit) {
                                this.invCheckFlag = false;
                                itemCheck = true;
                                break block27;
                            }
                            if (stack == ItemStack.field_190927_a || ZUtils.getFirstFilledSlotIndex(iInventory) < outputItems.size()) continue;
                            int outputSize = outputItems.size();
                            for (j = 0; j < outputSize; ++j) {
                                if (iInventory.func_70301_a(j) == ItemStack.field_190927_a) continue;
                                this.invCheckFlag = false;
                                itemCheck = false;
                                break block27;
                            }
                            int numExtraMoves = iInventory.func_70302_i_() - ZUtils.getFirstFilledSlotIndex(iInventory) - 1;
                            for (j = iInventory.func_70302_i_() - outputSize; j > 0; --j) {
                                int slot = iInventory.func_70302_i_();
                                iInventory.func_70299_a(slot - j - outputSize, iInventory.func_70301_a(slot - j));
                                iInventory.func_70299_a(slot - j, ItemStack.field_190927_a);
                            }
                            this.invCheckFlag = false;
                            itemCheck = true;
                            break block27;
                        }
                        if (stack != ItemStack.field_190927_a && (!stack.func_77969_a(outputItems.get(i3)) || stack.func_190916_E() + outputItems.get(i3).func_190916_E() > iInventory.func_70297_j_() || stack.func_190916_E() + outputItems.get(i3).func_190916_E() > stack.func_77976_d())) continue;
                        itemCheck = true;
                        break block27;
                    }
                }
            } else {
                for (IInventory iInventory : this.getItemOutPorts()) {
                    for (int i4 = 0; i4 < iInventory.func_70302_i_(); ++i4) {
                        if (!iInventory.func_70301_a(i4).func_190926_b()) continue;
                        --reservedSpotSize;
                    }
                }
                if (reservedSpotSize <= 0) {
                    itemCheck = true;
                }
            }
        }
        int[] fluidInputCounter = new int[recipe.getFluidIngredients().size()];
        for (IFluidHandlerInternal fluidInput : this.fluidInPorts) {
            for (int i5 = 0; i5 < recipe.getFluidIngredients().size(); ++i5) {
                FluidStack fluidStack = fluidInput.drainInternal(recipe.getFluidIngredients().get(i5), false);
                if (fluidStack == null) continue;
                int n = i5;
                fluidInputCounter[n] = fluidInputCounter[n] + fluidStack.amount;
            }
        }
        this.invCheckFlag = false;
        boolean bl = false;
        while (var8_17 < recipe.getFluidIngredients().size()) {
            if (fluidInputCounter[var8_17] < recipe.getFluidIngredients().get((int)var8_17).amount) {
                return false;
            }
            ++var8_17;
        }
        if (this.fluidOutPorts.size() < recipe.getFluidOutputs().size()) {
            return false;
        }
        int[] nArray = new int[recipe.getFluidOutputs().size()];
        for (i = 0; i < recipe.getFluidOutputs().size(); ++i) {
            nArray[i] = recipe.getFluidOutputs().get((int)i).amount;
        }
        for (i = 0; i < recipe.getFluidOutputs().size(); ++i) {
            int n = i;
            nArray[n] = nArray[n] - ((IFluidHandlerInternal)this.fluidOutPorts.get(i)).fillInternal(recipe.getFluidOutputs().get(i), false);
        }
        for (i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            return false;
        }
        return itemCheck;
    }

    public List<IRecipe> getMachineRecipeList() {
        LinkedList list = RecipesMachine.getInstance().getRecipes(this.getClass());
        return list != null ? list : new LinkedList();
    }

    @Override
    public void onInventoryUpdated() {
        if (!this.invCheckFlag && this.outputItemStacks == null && (this.outputFluidStacks == null || this.outputFluidStacks.isEmpty())) {
            IRecipe recipe;
            if (this.enabled && (recipe = this.getRecipe(this.getMachineRecipeList())) != null && this.canProcessRecipe(recipe)) {
                this.consumeItems(recipe);
                this.powerPerTick = (int)Math.ceil(this.getPowerMultiplierForRecipe(recipe) * (float)recipe.getPower());
                this.completionTime = Math.max((int)(this.getTimeMultiplierForRecipe(recipe) * (float)recipe.getTime()), 1);
                this.outputItemStacks = recipe.getOutput();
                this.outputFluidStacks = recipe.getFluidOutputs();
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.setMachineRunning(true);
            } else {
                this.setMachineRunning(false);
            }
        }
    }

    protected float getTimeMultiplierForRecipe(IRecipe recipe) {
        return this.getTimeMultiplier();
    }

    protected float getPowerMultiplierForRecipe(IRecipe recipe) {
        return 1.0f;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound tag;
        NBTTagList list;
        super.func_189515_b(nbt);
        if (this.outputItemStacks != null) {
            list = new NBTTagList();
            for (ItemStack itemStack : this.outputItemStacks) {
                if (itemStack == null) continue;
                tag = new NBTTagCompound();
                itemStack.func_77955_b(tag);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("outputItems", (NBTBase)list);
        }
        if (this.outputFluidStacks != null) {
            list = new NBTTagList();
            for (FluidStack fluidStack : this.outputFluidStacks) {
                if (fluidStack == null) continue;
                tag = new NBTTagCompound();
                fluidStack.writeToNBT(tag);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("outputFluids", (NBTBase)list);
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        int i;
        NBTTagList list;
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("outputItems")) {
            this.outputItemStacks = new LinkedList<ItemStack>();
            list = nbt.func_150295_c("outputItems", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                tag = list.func_150305_b(i);
                this.outputItemStacks.add(new ItemStack(tag));
            }
        }
        if (nbt.func_74764_b("outputFluids")) {
            this.outputFluidStacks = new LinkedList<FluidStack>();
            list = nbt.func_150295_c("outputFluids", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                tag = list.func_150305_b(i);
                this.outputFluidStacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag));
            }
        }
    }

    public boolean attemptCompleteStructure() {
        boolean completeStructure = super.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
        if (completeStructure) {
            this.onInventoryUpdated();
        }
        return completeStructure;
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
    }

    public static enum NetworkPackets {
        TOGGLE,
        POWERERROR;

    }
}

