/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.beneath.common.entity;

import com.shinoow.beneath.common.entity.EntityShadow;
import com.shinoow.beneath.common.network.PacketDispatcher;
import com.shinoow.beneath.common.network.client.SetTimerMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityHand
extends Entity {
    private static final DataParameter<Integer> DW_SHADOW_ID = EntityDataManager.func_187226_a(EntityFishHook.class, (DataSerializer)DataSerializers.field_187192_b);
    public EntityShadow shadow = null;

    public EntityHand(World world) {
        super(world);
    }

    public EntityHand(World world, EntityShadow entity, Entity target) {
        super(world);
        this.shadow = entity;
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + 1.62, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = (target.field_70165_t - entity.field_70165_t) * 0.7;
        this.field_70181_x = (target.field_70163_u + (double)target.func_70047_e() - 0.7 - this.field_70163_u) * 0.7;
        this.field_70179_y = (target.field_70161_v - entity.field_70161_v) * 0.7;
        double vH = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        if (vH >= 1.0E-7) {
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            this.field_70125_A = (float)(-Math.atan2(this.field_70181_x, vH) * 180.0 / Math.PI);
            double dX = this.field_70159_w / vH;
            double dZ = this.field_70179_y / vH;
            this.func_70012_b(entity.field_70165_t + dX, this.field_70163_u, entity.field_70161_v + dZ, this.field_70177_z, this.field_70125_A);
            this.calculateVelocity(this.field_70159_w, this.field_70181_x + vH * 0.2, this.field_70179_y, 1.0f, 14 - (world.func_175659_aa().func_151525_a() << 2));
        }
        this.updateAnglerId();
    }

    protected void func_70088_a() {
        this.func_70105_a(0.25f, 0.25f);
        this.func_184212_Q().func_187214_a(DW_SHADOW_ID, (Object)0);
    }

    public int getShadowId() {
        return (Integer)this.func_184212_Q().func_187225_a(DW_SHADOW_ID);
    }

    public void updateAnglerId() {
        if (this.shadow != null && this.shadow.func_145782_y() != this.getShadowId()) {
            this.func_184212_Q().func_187227_b(DW_SHADOW_ID, (Object)this.shadow.func_145782_y());
        }
    }

    public boolean func_70112_a(double d) {
        double d1 = this.func_174813_aQ().func_72320_b() * 256.0;
        return d < d1 * d1;
    }

    public void calculateVelocity(double vX, double vY, double vZ, float v, float variance) {
        float vi = MathHelper.func_76133_a((double)(vX * vX + vY * vY + vZ * vZ));
        vX /= (double)vi;
        vY /= (double)vi;
        vZ /= (double)vi;
        vX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        vY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        vZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        this.field_70159_w = vX *= (double)v;
        this.field_70181_x = vY *= (double)v;
        this.field_70179_y = vZ *= (double)v;
        float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vX, vZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vY, vH) * 180.0 / Math.PI);
    }

    public void func_70016_h(double vX, double vY, double vZ) {
        this.field_70159_w = vX;
        this.field_70181_x = vY;
        this.field_70179_y = vZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vX, vZ) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vY, vH) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        Entity entity;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.shadow == null || this.shadow.field_70128_L || this.func_70068_e((Entity)this.shadow) > 1024.0) {
                this.func_70106_y();
            }
            Vec3d posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d motionVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult object = this.field_70170_p.func_72933_a(posVec, motionVec);
            posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            motionVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (object != null) {
                motionVec = new Vec3d(object.field_72307_f.field_72450_a, object.field_72307_f.field_72448_b, object.field_72307_f.field_72449_c);
            }
            Entity entityHit = null;
            List entitiesInPath = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < entitiesInPath.size(); ++i) {
                double d1;
                AxisAlignedBB aabb;
                RayTraceResult object1;
                Entity entityInPath = (Entity)entitiesInPath.get(i);
                if (!entityInPath.func_70067_L() || entityInPath.func_70028_i((Entity)this.shadow) || (object1 = (aabb = entityInPath.func_174813_aQ().func_72321_a(0.3, 0.3, 0.3)).func_72327_a(posVec, motionVec)) == null || !((d1 = posVec.func_72438_d(object1.field_72307_f)) < d)) continue;
                entityHit = entityInPath;
                d = d1;
            }
            if (entityHit != null) {
                object = new RayTraceResult(entityHit);
            }
            if (object != null) {
                this.onImpact(object);
            }
        } else if (this.shadow == null && (entity = this.field_70170_p.func_73045_a(this.getShadowId())) instanceof EntityShadow) {
            this.shadow = (EntityShadow)entity;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float var16 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var16) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.99;
        this.field_70179_y *= 0.99;
        this.field_70181_x -= (double)this.getGravityVelocity();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void onImpact(RayTraceResult object) {
        if (object.field_72308_g != null) {
            double vX = this.shadow.field_70165_t - this.field_70165_t;
            double vY = this.shadow.field_70163_u - this.field_70163_u;
            double vZ = this.shadow.field_70161_v - this.field_70161_v;
            double v = Math.sqrt(vX * vX + vY * vY + vZ * vZ);
            double mult = 0.31;
            object.field_72308_g.field_70159_w = vX * mult;
            object.field_72308_g.field_70181_x = vY * mult + Math.sqrt(v) * 0.1;
            object.field_72308_g.field_70179_y = vZ * mult;
            object.field_72308_g.field_70122_E = false;
            if (object.field_72308_g instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new SetTimerMessage(), (EntityPlayerMP)object.field_72308_g);
                try {
                    ((EntityPlayerMP)object.field_72308_g).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(object.field_72308_g));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.func_70106_y();
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public void func_70014_b(NBTTagCompound tag) {
    }

    public void func_70037_a(NBTTagCompound tag) {
    }
}

