/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item;

import com.blakebr0.cucumber.item.ItemBase;
import com.blakebr0.cucumber.registry.ModRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMeta
extends ItemBase {
    private ModRegistry registry;
    public Map<Integer, MetaItem> items = new HashMap<Integer, MetaItem>();
    public ArrayList<Integer> metas = new ArrayList();
    public List<String> tooltip = new ArrayList<String>();

    public ItemMeta(String name, ModRegistry registry) {
        super(name);
        this.registry = registry;
        this.func_77627_a(true);
    }

    public ItemStack addItem(int meta, String name, boolean enabled) {
        if (!enabled) {
            return ItemStack.field_190927_a;
        }
        if (this.items.containsKey(meta)) {
            return ItemStack.field_190927_a;
        }
        this.items.put(meta, new MetaItem(name, enabled));
        this.metas.add(meta);
        return new ItemStack((Item)this, 1, meta);
    }

    public ItemStack addItem(int meta, String name, boolean enabled, List<String> tooltip) {
        if (!enabled) {
            return ItemStack.field_190927_a;
        }
        if (this.items.containsKey(meta)) {
            return ItemStack.field_190927_a;
        }
        this.items.put(meta, new MetaItem(name, enabled, tooltip));
        this.metas.add(meta);
        return new ItemStack((Item)this, 1, meta);
    }

    public ItemStack addItem(int meta, String name) {
        return this.addItem(meta, name, true);
    }

    public ItemStack addItem(int meta, String name, String ore, boolean enabled) {
        ItemStack stack = this.addItem(meta, name, enabled);
        this.registry.addOre(stack, ore);
        return stack;
    }

    public ItemStack addItem(int meta, String name, String ore, boolean enabled, List<String> tooltip) {
        ItemStack stack = this.addItem(meta, name, enabled, tooltip);
        this.registry.addOre(stack, ore);
        return stack;
    }

    public ItemStack addItem(int meta, String name, String ore) {
        return this.addItem(meta, name, ore, true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int meta : this.metas) {
                stacks.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        int i = stack.func_77960_j();
        if (!this.items.containsKey(i)) {
            return "invalid";
        }
        MetaItem item = this.items.get(i);
        return this.func_77658_a() + "_" + item.getName();
    }

    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        MetaItem item;
        int i = stack.func_77960_j();
        if (this.items.containsKey(i) && (item = this.items.get(i)).getTooltip() != null && !item.getTooltip().isEmpty()) {
            tooltip.addAll(item.getTooltip());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels() {
        for (Map.Entry<Integer, MetaItem> item : this.items.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)item.getKey(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString() + "_" + item.getValue().getName()));
        }
    }

    public void init() {
    }

    public class MetaItem {
        private String name;
        private boolean enabled;
        private List<String> tooltip;

        MetaItem(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        MetaItem(String name, boolean enabled, List<String> tooltip) {
            this.name = name;
            this.enabled = enabled;
            this.tooltip = tooltip;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public List<String> getTooltip() {
            return this.tooltip;
        }
    }
}

