/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomAreaOrientedBlock;
import com.buuz135.industrial.tile.mob.MobRelocatorTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class MobRelocatorBlock
extends CustomAreaOrientedBlock<MobRelocatorTile> {
    private float essenceMultiplier;
    private int damage;

    public MobRelocatorBlock() {
        super("mob_relocator", MobRelocatorTile.class, Material.field_151576_e, 1000, 40, CustomAreaOrientedBlock.RangeType.FRONT, 5, 2, true);
        this.func_149752_b(Float.MAX_VALUE);
    }

    @Override
    public void getMachineConfig() {
        super.getMachineConfig();
        this.essenceMultiplier = CustomConfiguration.config.getFloat("essenceMultiplier", "machines." + this.getRegistryName().func_110623_a().toString(), 1.0f, 0.0f, 2.1474836E9f, "Mob essence multiplier based on the XP orb. Essence mb = xpOrbValue*20*essenceMultiplier");
        this.damage = CustomConfiguration.config.getInt("damage", "machines." + this.getRegistryName().func_110623_a().toString(), 300, 0, Integer.MAX_VALUE, "Amount of damage that the machine will do");
    }

    public float getEssenceMultiplier() {
        return this.essenceMultiplier;
    }

    public int getDamage() {
        return this.damage;
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"psp", "bmb", "grg", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('s'), Items.field_151040_l, Character.valueOf('b'), Items.field_151122_aG, Character.valueOf('m'), MachineCaseItem.INSTANCE, Character.valueOf('g'), "gearGold", Character.valueOf('r'), Items.field_151137_ax});
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.MOB;
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        List<String> t = super.getTooltip(stack);
        t.add(new TextComponentTranslation("text.industrialforegoing.tooltip.adult_filter", new Object[0]).func_150254_d());
        t.add(new TextComponentTranslation("text.industrialforegoing.tooltip.fortune_addon", new Object[0]).func_150254_d());
        return t;
    }
}

