/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.client.gui;

import com.m4thg33k.tombmanygraves.client.gui.ModBaseGui;
import com.m4thg33k.tombmanygraves.client.gui.Scrollbar;
import com.m4thg33k.tombmanygraves.invman.GraveInventoryManager;
import com.m4thg33k.tombmanygraves.invman.InventoryHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;

public class GuiDeathItems
extends ModBaseGui {
    private InventoryHolder inventoryHolder = new InventoryHolder();
    private Map<String, Tuple<String, List<String>>> dataMap = null;
    private List<String> header;
    private List<String> EOF;
    private Scrollbar scrollbar;
    private int numLines = 0;
    public static final String BREAK = "-----------------------------";

    public GuiDeathItems(EntityPlayer player, ItemStack deathList) {
        super(200, 150);
        this.inventoryHolder.readFromNBT(deathList.func_77978_p());
        this.dataMap = this.inventoryHolder.getItemStackStringsForGui();
        this.createHeader();
        this.numLines += this.header.size();
        if (this.dataMap.size() > 0) {
            AtomicInteger linesWithin = new AtomicInteger();
            this.dataMap.entrySet().forEach(entry -> linesWithin.addAndGet(3 + ((List)((Tuple)entry.getValue()).func_76340_b()).size()));
            this.numLines += linesWithin.get();
        }
        this.EOF = new ArrayList<String>();
        this.EOF.add(BREAK);
        this.EOF.add("End Of File");
        this.EOF.add(BREAK);
        this.numLines += 3;
        this.scrollbar = new Scrollbar(this.xSize - 12, 0, 12, this.ySize);
        this.scrollbar.setScrollDelta(1.0f);
        if (this.numLines <= 13) {
            this.scrollbar.setCanScroll(false);
        }
    }

    public void func_146278_c(int tint) {
        this.bindTexture("deathlistbackground.png");
        this.drawTexture(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.xSize, this.ySize);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.scrollbar.update(this, mouseX, mouseY);
        this.scrollbar.draw(this);
        AtomicInteger text_height = new AtomicInteger(this.drawPortion(this.header, 0));
        GraveInventoryManager.getInstance().getSortedGuiNames().forEach(name -> {
            Tuple<String, List<String>> entry = this.dataMap.get(name);
            if (entry != null) {
                text_height.set(this.drawInventoryItems(text_height.get(), (String)entry.func_76341_a(), (List)entry.func_76340_b(), GraveInventoryManager.getGuiColorForInventory(name)));
            }
        });
        this.drawStringList(text_height.get(), this.EOF, 0xFF0000);
    }

    private int drawPortion(List<String> lines, int startHeight) {
        return this.drawPortion(lines, startHeight, 0);
    }

    private int drawPortion(List<String> lines, int startHeight, int draw_color) {
        int gLeft = this.getGuiLeft();
        int gTop = this.getGuiTop();
        int counter = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int height = startHeight + 10 * i + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
            ++counter;
            if (height < 4 || height >= this.ySize - 12) continue;
            this.field_146289_q.func_78276_b(lines.get(i), gLeft + 12, gTop + height, draw_color);
        }
        return startHeight + counter * 10;
    }

    private int calcHeight(int startHeight, int numLines) {
        return startHeight + 10 * numLines + (int)this.scrollbar.getCurrentScroll() * -10 + 10;
    }

    private void drawString(String text, int heightOffset, int color) {
        this.field_146289_q.func_78276_b(text, this.getGuiLeft() + 12, this.getGuiTop() + heightOffset, color);
    }

    private void drawBreak(int heightOffest, int color) {
        this.drawString(BREAK, heightOffest, color);
    }

    private boolean drawStringList(int startHeight, List<String> strings) {
        return this.drawStringList(startHeight, strings, 0);
    }

    private boolean drawStringList(int startHeight, List<String> strings, int color) {
        for (int i = 0; i < strings.size(); ++i) {
            int height = this.calcHeight(startHeight, i);
            if (height >= this.ySize - 12) {
                return false;
            }
            if (height < 4) continue;
            this.drawString(strings.get(i), height, color);
        }
        return true;
    }

    private int drawInventoryItems(int startHeight, String inventoryName, List<String> itemStrings, int color) {
        int returnHeight = startHeight + 10 * (3 + itemStrings.size());
        int height = this.calcHeight(startHeight, 0);
        if (height >= this.ySize - 12) {
            return returnHeight;
        }
        if (height >= 4) {
            this.drawBreak(height, color);
        }
        if ((height = this.calcHeight(startHeight, 1)) >= this.ySize - 12) {
            return returnHeight;
        }
        if (height >= 4) {
            this.drawString(inventoryName, height, color);
        }
        if ((height = this.calcHeight(startHeight, 2)) >= this.ySize - 12) {
            return returnHeight;
        }
        if (height >= 4) {
            this.drawBreak(height, color);
        }
        this.drawStringList(startHeight + 30, itemStrings);
        return returnHeight;
    }

    private void createHeader() {
        this.header = new ArrayList<String>();
        this.header.add(this.inventoryHolder.getPlayerName());
        BlockPos pos = this.inventoryHolder.getPosition();
        if (pos.func_177956_o() < 0) {
            this.header.add("No grave exists.");
        } else {
            this.header.add("Grave at: (x,y,z)=(" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + ")");
        }
        this.header.add("Timestamp: " + this.inventoryHolder.getTimestamp());
    }

    public boolean func_73868_f() {
        return false;
    }
}

