/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.commands;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;

public abstract class CommandBase
implements ICommand {
    public String COMMAND_NAME;
    protected List<String> aliases;
    protected int requiredPermissionLevel;
    protected boolean requireRealPlayer = false;

    public CommandBase(@Nonnull String name, int requiredPermissionLevel, boolean requireRealPlayer) {
        this.COMMAND_NAME = name;
        this.requiredPermissionLevel = requiredPermissionLevel;
        this.requireRealPlayer = requireRealPlayer;
        this.aliases = new ArrayList<String>();
    }

    @Nonnull
    public String func_71517_b() {
        return this.COMMAND_NAME;
    }

    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    @ParametersAreNonnullByDefault
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !(this.requireRealPlayer && !(sender instanceof EntityPlayer) || this.requiredPermissionLevel != 0 && !sender.func_70003_b(this.requiredPermissionLevel, this.func_71517_b()));
    }

    public int compareTo(@Nonnull ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    public static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public static List<String> getListOfStringMatchingLastWord(String[] args, String ... possibilities) {
        return CommandBase.getListOfStringMatchingLastWord(args, Arrays.asList(possibilities));
    }

    public static List<String> getListOfStringMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (String s1 : Iterables.transform(possibleCompletions, (Function)Functions.toStringFunction())) {
                if (!CommandBase.doesStringStartWith(s, s1)) continue;
                list.add(s1);
            }
        }
        if (list.isEmpty()) {
            for (Object object : possibleCompletions) {
                if (!(object instanceof ResourceLocation) || !CommandBase.doesStringStartWith(s, ((ResourceLocation)object).func_110623_a())) continue;
                list.add(String.valueOf(object));
            }
        }
        return list;
    }
}

