/*
 * Decompiled with CFR 0.152.
 */
package jackyy.gunpowderlib.helper;

import java.text.NumberFormat;
import java.util.Map;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class StringHelper {
    public static String getTierText(String modid, int tier) {
        return StringHelper.localize(modid, "tooltip.tier", tier);
    }

    public static String getShiftText(String modid) {
        return TextFormatting.GRAY + StringHelper.localize(modid, "tooltip.hold_shift", TextFormatting.YELLOW.toString() + TextFormatting.ITALIC + StringHelper.localize(modid, "tooltip.hold_shift.shift", new Object[0]) + TextFormatting.RESET + TextFormatting.GRAY);
    }

    public static String getCtrlText(String modid) {
        return TextFormatting.GRAY + StringHelper.localize(modid, "tooltip.hold_ctrl", TextFormatting.AQUA.toString() + TextFormatting.ITALIC + StringHelper.localize(modid, "tooltip.hold_ctrl.ctrl", new Object[0]) + TextFormatting.RESET + TextFormatting.GRAY);
    }

    public static String formatNumber(long number) {
        return NumberFormat.getInstance().format(number);
    }

    public static String getModNameByID(String modid) {
        Map indexedModList = Loader.instance().getIndexedModList();
        ModContainer modContainer = (ModContainer)indexedModList.get(modid);
        if (modContainer != null) {
            return modContainer.getName();
        }
        return modid;
    }

    public static String formatHarvestLevel(String modid, int harvestLevel) {
        return StringHelper.localize(modid, "harvest_level." + harvestLevel, new Object[0]).equals(modid + ".harvest_level." + harvestLevel) ? String.valueOf(harvestLevel) : StringHelper.localize(modid, "harvest_level." + harvestLevel, new Object[0]);
    }

    public static String localize(String modid, String unlocalized, Object ... args) {
        String toLocalize = modid + "." + unlocalized;
        if (args != null && args.length > 0) {
            return I18n.func_74837_a((String)toLocalize, (Object[])args);
        }
        return I18n.func_74838_a((String)toLocalize);
    }
}

