/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.music.MusicInstrument;

public class CeremonyDanseMacabre
extends Ceremony {
    public CeremonyDanseMacabre(String name, int musicNeeded, int maxStartupTime, MusicInstrument ... instruments) {
        super(name, musicNeeded, maxStartupTime, instruments);
    }

    @Override
    public void effect(World world, BlockPos pos, CeremonyEffectContext context) {
        int radius = 6;
        if (!world.field_72995_K && context.getTime() % 20 == 0) {
            TotemicEntityUtil.getEntitiesInRange(EntityItem.class, world, pos, radius, radius).forEach(entity -> {
                if (entity.func_92059_d().func_77973_b() == Items.field_151078_bh && world.field_73012_v.nextInt(4) == 0) {
                    if (entity.field_71093_bK == -1) {
                        EntityPigZombie pigZombie = new EntityPigZombie(world);
                        this.summon(world, (EntityZombie)pigZombie, (EntityItem)entity);
                    } else if (world.field_73012_v.nextInt(10) == 0) {
                        EntityZombieVillager zombieVillager = new EntityZombieVillager(world);
                        this.summon(world, (EntityZombie)zombieVillager, (EntityItem)entity);
                    } else {
                        EntityZombie zombie = new EntityZombie(world);
                        this.summon(world, zombie, (EntityItem)entity);
                    }
                }
            });
        }
    }

    private void summon(World world, EntityZombie zombie, EntityItem item) {
        BlockPos spawnPos = item.func_180425_c();
        double x = item.field_70165_t;
        double y = item.field_70163_u;
        double z = item.field_70161_v;
        if (world.func_175623_d(spawnPos) && world.func_175623_d(spawnPos.func_177984_a())) {
            zombie.func_70107_b(x, y, z);
            zombie.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 600, 1));
            zombie.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 600, 1));
            world.func_72838_d((Entity)zombie);
            if (item.func_92059_d().func_190916_E() == 1) {
                item.func_70106_y();
            } else {
                ItemStack stack = item.func_92059_d().func_77946_l();
                stack.func_190918_g(1);
                item.func_92058_a(stack);
            }
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, 24, 0.6, 0.5, 0.6, 1.0, new int[0]);
        }
    }

    @Override
    public int getEffectTime() {
        return 900;
    }

    @Override
    public int getMusicPer5() {
        return 6;
    }
}

