/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.util.EntityUtil;

public class CeremonyFertility
extends Ceremony {
    private static final Set<EntityVillager> matedVillagers = Collections.newSetFromMap(new WeakHashMap());

    public CeremonyFertility(String name, int musicNeeded, int maxStartupTime, MusicInstrument ... instruments) {
        super(name, musicNeeded, maxStartupTime, instruments);
    }

    @Override
    public void effect(World world, BlockPos pos, CeremonyEffectContext context) {
        int radius = 8;
        if (!world.field_72995_K && context.getTime() % 20 == 0) {
            for (Entity entity : EntityUtil.listEntitiesInRange(EntityLiving.class, world, pos, radius, radius, e -> e instanceof EntityAnimal || e instanceof EntityVillager)) {
                if (entity instanceof EntityAnimal) {
                    EntityAnimal animal = (EntityAnimal)entity;
                    if (animal.func_70874_b() != 0 || animal.func_70880_s() || !this.consumeBreedingItem(world, pos, animal)) continue;
                    animal.func_146082_f(null);
                    break;
                }
                EntityVillager villager = (EntityVillager)entity;
                if (villager.func_70874_b() != 0 || matedVillagers.contains(villager) || villager.func_70941_o() || !this.consumeBreedingItem(world, pos, villager)) continue;
                matedVillagers.add(villager);
                villager.func_175549_o(true);
                villager.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIVillagerFertility(villager));
                world.func_72960_a((Entity)villager, (byte)12);
                break;
            }
        }
        if (context.getTime() % 20 == 0) {
            for (BlockPos blockPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius))) {
                IBlockState state = world.func_180495_p(blockPos);
                Block block = state.func_177230_c();
                if (!(block instanceof BlockSapling) || block == ModBlocks.cedar_sapling) continue;
                world.func_180501_a(blockPos, ModBlocks.cedar_sapling.func_176223_P(), 3);
                this.spawnParticles(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
            }
        }
    }

    private boolean consumeBreedingItem(World world, BlockPos pos, EntityAnimal animal) {
        int radius = 8;
        List<EntityItem> breedingItems = EntityUtil.listEntitiesInRange(EntityItem.class, world, pos, radius, radius, e -> animal.func_70877_b(e.func_92059_d()));
        if (!breedingItems.isEmpty()) {
            if (world.field_73012_v.nextInt(3) < 2) {
                EntityItem entityItem = breedingItems.get(0);
                entityItem.func_92059_d().func_190918_g(1);
                if (entityItem.func_92059_d().func_190926_b()) {
                    entityItem.func_70106_y();
                }
            }
            return true;
        }
        return false;
    }

    private boolean consumeBreedingItem(World world, BlockPos pos, EntityVillager villager) {
        int radius = 8;
        List<EntityItem> breedingItems = EntityUtil.listEntitiesInRange(EntityItem.class, world, pos, radius, radius, e -> e.func_92059_d().func_77973_b() == Items.field_151166_bC);
        if (!breedingItems.isEmpty()) {
            EntityItem entityItem = breedingItems.get(0);
            entityItem.func_92059_d().func_190918_g(1);
            if (entityItem.func_92059_d().func_190926_b()) {
                entityItem.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    public int getEffectTime() {
        return 400;
    }

    @Override
    public int getMusicPer5() {
        return 6;
    }

    private void spawnParticles(World world, double x, double y, double z) {
        if (world.field_72995_K) {
            double dx = world.field_73012_v.nextGaussian();
            double dy = world.field_73012_v.nextGaussian() * 0.5;
            double dz = world.field_73012_v.nextGaussian();
            double velY = world.field_73012_v.nextGaussian();
            for (int i = 0; i < 10; ++i) {
                world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, x + dx, y + dy, z + dz, 0.0, velY, 0.0, new int[0]);
            }
        }
    }

    private static class EntityAIVillagerFertility
    extends EntityAIBase {
        private final EntityVillager villager;
        private EntityVillager mate;
        private final World world;
        private int matingTimeout;

        public EntityAIVillagerFertility(EntityVillager villagerIn) {
            this.villager = villagerIn;
            this.world = villagerIn.field_70170_p;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (this.villager.func_175550_n(true)) {
                EntityVillager mate = (EntityVillager)this.world.func_72857_a(EntityVillager.class, this.villager.func_174813_aQ().func_72314_b(8.0, 3.0, 8.0), (Entity)this.villager);
                if (mate == null) {
                    return false;
                }
                this.mate = mate;
                return mate.func_70874_b() == 0 && mate.func_175550_n(true) && matedVillagers.contains(mate);
            }
            return false;
        }

        public void func_75249_e() {
            this.matingTimeout = 300;
            this.villager.func_70947_e(true);
        }

        public void func_75251_c() {
            this.mate = null;
            this.villager.func_70947_e(false);
            matedVillagers.remove(this.villager);
            matedVillagers.remove(this.mate);
            this.villager.field_70714_bg.func_85156_a((EntityAIBase)this);
        }

        public boolean func_75253_b() {
            return this.matingTimeout >= 0 && this.villager.func_70874_b() == 0 && this.villager.func_175550_n(false) && matedVillagers.contains(this.mate);
        }

        public void func_75246_d() {
            --this.matingTimeout;
            this.villager.func_70671_ap().func_75651_a((Entity)this.mate, 10.0f, 30.0f);
            if (this.villager.func_70068_e((Entity)this.mate) > 2.25) {
                this.villager.func_70661_as().func_75497_a((Entity)this.mate, 0.25);
            } else if (this.matingTimeout == 0 && this.mate.func_70941_o()) {
                this.giveBirth();
            }
            if (this.villager.func_70681_au().nextInt(35) == 0) {
                this.world.func_72960_a((Entity)this.villager, (byte)12);
            }
        }

        private void giveBirth() {
            EntityVillager entityvillager = this.villager.func_90011_a((EntityAgeable)this.mate);
            this.mate.func_70873_a(6000);
            this.villager.func_70873_a(6000);
            this.mate.func_175549_o(false);
            this.villager.func_175549_o(false);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this.villager, (EntityLiving)this.mate, (EntityAgeable)entityvillager);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getChild() == null) {
                return;
            }
            entityvillager = event.getChild();
            entityvillager.func_70873_a(-24000);
            entityvillager.func_70012_b(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, 0.0f, 0.0f);
            this.world.func_72838_d((Entity)entityvillager);
            this.world.func_72960_a((Entity)entityvillager, (byte)12);
        }
    }
}

