/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.datafix;

import java.util.Locale;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.datafix.IFixableData;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.util.MiscUtil;

public class CamelCaseNamesTiles
implements IFixableData {
    public int func_188216_a() {
        return 1010;
    }

    static String checkAndFixName(String name, String description) {
        if (!name.contains(":") || !name.equals(name.toLowerCase(Locale.ROOT))) {
            String oldName = name;
            name = MiscUtil.fixResourceName(oldName);
            Totemic.logger.debug("Fixed {} name: '{}' -> '{}'", (Object)description, (Object)oldName, (Object)name);
        }
        return name;
    }

    static NBTTagCompound fixCompoundKeys(NBTTagCompound tag, String description) {
        NBTTagCompound fixed = new NBTTagCompound();
        for (String name : tag.func_150296_c()) {
            fixed.func_74782_a(CamelCaseNamesTiles.checkAndFixName(name, description), tag.func_74781_a(name));
        }
        return fixed;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        block4 : switch (compound.func_74779_i("id")) {
            case "totemic:totem_base": {
                byte state = compound.func_74771_c("state");
                switch (state) {
                    case 1: {
                        NBTTagList selectorsTag = compound.func_150295_c("selectors", 8);
                        for (int i = 0; i < selectorsTag.func_74745_c(); ++i) {
                            String name = CamelCaseNamesTiles.checkAndFixName(selectorsTag.func_150307_f(i), "Music Instrument");
                            selectorsTag.func_150304_a(i, (NBTBase)new NBTTagString(name));
                        }
                        break block4;
                    }
                    case 2: {
                        String ceremonyName = compound.func_74779_i("ceremony");
                        compound.func_74778_a("ceremony", CamelCaseNamesTiles.checkAndFixName(ceremonyName, "Ceremony"));
                        NBTTagCompound ceremonyMusic = compound.func_74775_l("ceremonyMusic");
                        compound.func_74782_a("ceremonyMusic", (NBTBase)CamelCaseNamesTiles.fixCompoundKeys(ceremonyMusic, "Music Instrument"));
                        NBTTagCompound timesPlayed = compound.func_74775_l("timesPlayed");
                        compound.func_74782_a("timesPlayed", (NBTBase)CamelCaseNamesTiles.fixCompoundKeys(timesPlayed, "Music Instrument"));
                        break;
                    }
                    case 3: {
                        String ceremonyName = compound.func_74779_i("ceremony");
                        compound.func_74778_a("ceremony", CamelCaseNamesTiles.checkAndFixName(ceremonyName, "Ceremony"));
                    }
                }
                break;
            }
            case "totemic:totem_pole": {
                if (!compound.func_150297_b("effect", 8)) break;
                String name = compound.func_74779_i("effect");
                compound.func_74778_a("effect", CamelCaseNamesTiles.checkAndFixName(name, "Totem Effect"));
            }
        }
        return compound;
    }
}

