/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.command;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.command.SubCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.StringUtils;

public class SubCommandBatchRun
extends SubCommand {
    public static final FilenameFilter FILTER_FILES = new FilenameFilter(){

        @Override
        public boolean accept(File pathName, String name) {
            return new File(pathName, name).isFile();
        }
    };

    public SubCommandBatchRun(CommandTellme baseCommand) {
        super(baseCommand);
        this.addSubCommandHelp("_generic", "Runs commands from files inside config/tellme/batch_commands/");
    }

    @Override
    public String getName() {
        return "batch-run";
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        return CommandBase.func_175762_a((String[])args, this.getExistingBatchFileNames());
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException(this.getSubCommandUsagePre() + " batch-run <filename>", new Object[0]);
        }
        this.runBatchCommands(server, sender, args[0]);
    }

    private void runBatchCommands(MinecraftServer server, ICommandSender sender, String fileName) {
        File batchFile = this.getBatchCommandFile(fileName);
        if (batchFile != null) {
            ICommandManager manager = server.func_71187_D();
            List<String> commands = this.getCommands(batchFile);
            for (String command : commands) {
                TellMe.logger.info("Running a command: '{}'", (Object)command);
                manager.func_71556_a(sender, command);
            }
        }
    }

    private List<String> getCommands(File batchFile) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(batchFile.getAbsolutePath())));
            while ((line = br.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line) || line.charAt(0) == '#') continue;
                lines.add(line);
            }
            br.close();
        }
        catch (IOException e) {
            TellMe.logger.warn("Failed to read commands from a batch file '{}'", (Object)batchFile.getAbsolutePath());
        }
        return lines;
    }

    @Nullable
    private File getBatchCommandFile(String fileName) {
        File cfgDir = new File(TellMe.configDirPath);
        File batchFile = new File(new File(cfgDir, "batch_commands"), fileName);
        return batchFile.exists() && batchFile.isFile() ? batchFile : null;
    }

    private List<String> getExistingBatchFileNames() {
        File dir = new File(new File(TellMe.configDirPath), "batch_commands");
        if (dir.isDirectory()) {
            String[] names = dir.list(FILTER_FILES);
            return Arrays.asList(names);
        }
        return Collections.emptyList();
    }
}

