/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.command;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.TileEntityDump;
import fi.dy.masa.tellme.util.WorldUtils;
import fi.dy.masa.tellme.util.chunkprocessor.Locate;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SubCommandLocate
extends SubCommand {
    public SubCommandLocate(CommandTellme baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("block");
        this.subSubCommands.add("entity");
        this.subSubCommands.add("te");
        this.addSubCommandHelp("_generic", "Finds blocks, entities or TileEntities from the world (from loaded chunks - optionally loading chunks first)");
    }

    @Override
    public String getName() {
        return "locate";
    }

    private void printUsageLocate(ICommandSender sender) {
        String pre = this.getSubCommandUsagePre();
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <block | entity | te> <print | dump[-csv]> all-loaded-chunks [all-dims | dimensionId] <name1 name2 ...>"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <block | entity | te> <print | dump[-csv]> chunk-radius <radius> [dimension] [x y z (of the center)] <name1 name2 ...>"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <block | entity | te> <print | dump[-csv]> range <x-distance> <y-distance> <z-distance> [dimension] [x y z (of the center)] <name1 name2 ...>"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <block | entity | te> <print | dump[-csv]> box <x1> <y1> <z1> <x2> <y2> <z2> [dimension] <name1 name2 ...>"));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 1) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"block", "entity", "te"});
        }
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"print", "dump", "dump-csv"});
        }
        if (args.length == 3) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"all-loaded-chunks", "box", "chunk-radius", "range"});
        }
        if (args.length >= 4 && args.length <= 9 && args[2].equals("box")) {
            int index = args.length >= 4 && args.length <= 6 ? 3 : 6;
            return CommandBase.func_175771_a((String[])args, (int)index, (BlockPos)targetPos);
        }
        if (args.length > this.getDimensionArgIndex(args[2])) {
            if (args[0].equals("block")) {
                return CommandBase.func_175762_a((String[])args, (Collection)ForgeRegistries.BLOCKS.getKeys());
            }
            if (args[0].equals("entity")) {
                return CommandBase.func_175762_a((String[])args, (Collection)ForgeRegistries.ENTITIES.getKeys());
            }
            if (args[0].equals("te")) {
                return CommandBase.func_175762_a((String[])args, (Collection)TileEntityDump.getTileEntityRegistry().func_148742_b());
            }
        }
        return Collections.emptyList();
    }

    private boolean isValidCommand(String[] args, ICommandSender sender) {
        if (args.length < 4) {
            this.sendMessage(sender, "Too few arguments", new Object[0]);
            return false;
        }
        Locate.LocateType locateType = Locate.LocateType.fromArg(args[0]);
        Locate.OutputType outputType = Locate.OutputType.fromArg(args[1]);
        String areaType = args[2];
        if (locateType == Locate.LocateType.INVALID || outputType == Locate.OutputType.INVALID) {
            this.sendMessage(sender, "Invalid target type or output type", new Object[0]);
            return false;
        }
        int requiredArgs = this.getDimensionArgIndex(areaType) + 1;
        if (requiredArgs == 0) {
            this.sendMessage(sender, "Invalid area type", new Object[0]);
            return false;
        }
        if (args.length < requiredArgs) {
            this.sendMessage(sender, "Too few arguments for the given area type", new Object[0]);
            return false;
        }
        if (areaType.equals("chunk-radius")) {
            return SubCommandLocate.isInteger(args[3]) && (args.length >= 6 && !SubCommandLocate.isInteger(args[5]) || args.length >= 8 && SubCommandLocate.getNumberOfTrailingIntegers(args, 6) == 4 || args.length >= 9 && SubCommandLocate.getNumberOfTrailingIntegers(args, 7) == 5);
        }
        if (areaType.equals("range")) {
            return SubCommandLocate.getNumberOfTrailingIntegers(args, 5) == 3 && (!SubCommandLocate.isInteger(args[6]) || args.length >= 8 && !SubCommandLocate.isInteger(args[7]) || args.length >= 10 && SubCommandLocate.getNumberOfTrailingIntegers(args, 8) == 6 || args.length >= 11 && SubCommandLocate.getNumberOfTrailingIntegers(args, 9) == 7);
        }
        if (areaType.equals("box")) {
            return SubCommandLocate.getNumberOfTrailingIntegers(args, 8) == 6 && (!SubCommandLocate.isInteger(args[9]) || args.length >= 11 && SubCommandLocate.getNumberOfTrailingIntegers(args, 9) == 7);
        }
        return true;
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos;
        int dimArgIndex;
        if (!this.isValidCommand(args, sender)) {
            this.sendMessage(sender, "Usage:", new Object[0]);
            this.printUsageLocate(sender);
            return;
        }
        String typeStr = args[0];
        String outStr = args[1];
        Locate.LocateType locateType = Locate.LocateType.fromArg(typeStr);
        Locate.OutputType outputType = Locate.OutputType.fromArg(outStr);
        String areaType = args[2];
        int namesStart = dimArgIndex = this.getDimensionArgIndex(areaType);
        if (args.length > dimArgIndex && (SubCommandLocate.isInteger(args[dimArgIndex]) || areaType.equals("all-loaded-chunks") && args[dimArgIndex].equals("all-dims"))) {
            ++namesStart;
        }
        World world = this.getWorld(areaType, args, sender, server);
        BlockPos blockPos = pos = sender instanceof EntityPlayer ? sender.func_180425_c() : WorldUtils.getSpawnPoint(world);
        if (areaType.equals("chunk-radius") || areaType.equals("range")) {
            int z;
            int y;
            int x;
            if (args.length >= dimArgIndex + 5 && SubCommandLocate.getNumberOfTrailingIntegers(args, dimArgIndex + 3) >= 4) {
                x = Integer.parseInt(args[dimArgIndex + 1]);
                y = Integer.parseInt(args[dimArgIndex + 2]);
                z = Integer.parseInt(args[dimArgIndex + 3]);
                pos = new BlockPos(x, y, z);
                namesStart += 3;
            } else if (args.length >= dimArgIndex + 4 && SubCommandLocate.getNumberOfTrailingIntegers(args, dimArgIndex + 2) >= 3) {
                x = Integer.parseInt(args[dimArgIndex]);
                y = Integer.parseInt(args[dimArgIndex + 1]);
                z = Integer.parseInt(args[dimArgIndex + 2]);
                pos = new BlockPos(x, y, z);
                namesStart += 2;
            }
        }
        HashSet<String> filters = new HashSet<String>();
        switch (locateType) {
            case BLOCK: {
                break;
            }
            case ENTITY: {
                break;
            }
            case TILE_ENTITY: {
                break;
            }
            default: {
                this.sendMessage(sender, "Usage:", new Object[0]);
                this.printUsageLocate(sender);
                return;
            }
        }
        for (int i = namesStart; i < args.length; ++i) {
            filters.add(args[i]);
        }
        if (filters.isEmpty()) {
            this.sendMessage(sender, "Usage:", new Object[0]);
            this.printUsageLocate(sender);
            return;
        }
        Locate locate = Locate.create(locateType, outputType, filters);
        if (areaType.equals("range")) {
            try {
                int rx = Math.abs(CommandBase.func_175755_a((String)args[3]));
                int ry = Math.abs(CommandBase.func_175755_a((String)args[4]));
                int rz = Math.abs(CommandBase.func_175755_a((String)args[5]));
                this.sendMessage(sender, "Searching...", new Object[0]);
                locate.processChunks(world, pos, rx, ry, rz);
                this.outputData(locate, sender);
            }
            catch (NumberInvalidException e) {
                throw new WrongUsageException("/tellme locate " + typeStr + " " + outStr + " range <x-distance> <y-distance> <z-distance> [dimension] [x y z (of the center)] <name1 name2 ...>", new Object[0]);
            }
        }
        if (areaType.equals("box")) {
            try {
                BlockPos pos1 = SubCommandLocate.parseBlockPos(pos, args, 3, false);
                BlockPos pos2 = SubCommandLocate.parseBlockPos(pos, args, 6, false);
                this.sendMessage(sender, "Searching...", new Object[0]);
                locate.processChunks(world, pos1, pos2);
                this.outputData(locate, sender);
            }
            catch (NumberInvalidException e) {
                throw new WrongUsageException("/tellme locate " + typeStr + " " + outStr + " box <x1> <y1> <z1> <x2> <y2> <z2> [dimension] <name1 name2 ...>", new Object[0]);
            }
        }
        if (areaType.equals("all-loaded-chunks")) {
            this.sendMessage(sender, "Searching...", new Object[0]);
            if (args[3].equals("all-dims")) {
                Integer[] ids;
                locate.setPrintDimension(true);
                Integer[] pos2 = ids = DimensionManager.getIDs();
                int rz = pos2.length;
                for (int i = 0; i < rz; ++i) {
                    int dim = pos2[i];
                    WorldServer worldTmp = DimensionManager.getWorld((int)dim);
                    if (worldTmp == null) continue;
                    locate.processChunks(TellMe.proxy.getLoadedChunks((World)worldTmp));
                }
            } else {
                locate.processChunks(TellMe.proxy.getLoadedChunks(world));
            }
            this.outputData(locate, sender);
        } else if (areaType.equals("chunk-radius")) {
            int radius = 0;
            try {
                radius = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                throw new WrongUsageException("/tellme locate " + typeStr + " " + outStr + " chunk-radius <radius> [dimension] [x y z (of the center)] <name1 name2 ...>", new Object[0]);
            }
            int chunkCount = (radius * 2 + 1) * (radius * 2 + 1);
            this.sendMessage(sender, "Loading all the " + chunkCount + " chunks in the given radius of " + radius + " chunks ...", new Object[0]);
            List<Chunk> chunks = WorldUtils.loadAndGetChunks(world, pos, radius);
            this.sendMessage(sender, "Searching in the selected " + chunks.size() + " chunks...", new Object[0]);
            locate.processChunks(chunks);
            this.outputData(locate, sender);
        }
    }

    private void outputData(Locate locate, ICommandSender sender) {
        List<String> lines = locate.getLines();
        if (locate.getOutputType() == Locate.OutputType.PRINT) {
            DataDump.printDataToLogger(lines);
            this.sendMessage(sender, "Command output printed to console", new Object[0]);
        } else {
            File file = DataDump.dumpDataToFile("locate_" + locate.getLocateType().toString().toLowerCase(), lines);
            SubCommandLocate.sendClickableLinkMessage(sender, "Output written to file %s", file);
        }
    }

    private World getWorld(String areaType, String[] args, ICommandSender sender, MinecraftServer server) throws CommandException {
        int index = this.getDimensionArgIndex(areaType);
        World world = sender.func_130014_f_();
        if (index >= 0 && args.length > index) {
            String dimStr = args[index];
            try {
                int dimension = Integer.parseInt(dimStr);
                world = server.func_71218_a(dimension);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (world == null) {
                throw new CommandException("Could not load the target dimension", new Object[0]);
            }
        }
        return world;
    }

    private int getDimensionArgIndex(String areaType) {
        int index = -1;
        switch (areaType) {
            case "all-loaded-chunks": {
                index = 3;
                break;
            }
            case "chunk-radius": {
                index = 4;
                break;
            }
            case "range": {
                index = 6;
                break;
            }
            case "box": {
                index = 9;
            }
        }
        return index;
    }
}

