/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.config;

import fi.dy.masa.tellme.TellMe;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Configs {
    public static File configurationFile;
    public static Configuration config;
    public static final String CATEGORY_GENERIC = "Generic";
    public static boolean enableDebugItemForBlockAndEntities;
    public static boolean enableDebugItemForItems;
    private static String debugItemNameBlocks;
    private static String debugItemNameItems;
    public static ItemStack debugItemBlocks;
    public static ItemStack debugItemItems;

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("tellme".equals(event.getModID())) {
            Configs.loadConfigs(config);
        }
    }

    public static void loadConfigsFromFile(File configFile) {
        configurationFile = configFile;
        config = new Configuration(configFile, null, true);
        config.load();
        Configs.loadConfigs(config);
    }

    public static void loadConfigs(Configuration conf) {
        Property prop = conf.get(CATEGORY_GENERIC, "enableDebugItemForBlocksAndEntities", true);
        prop.setComment("Enables the debug item to right click on blocks or entities");
        enableDebugItemForBlockAndEntities = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableDebugItemForItems", true);
        prop.setComment("Enables the debug item to right with to dump data from the item next to the right of it on the hotbar");
        enableDebugItemForItems = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "debugItemNameBlocks", "minecraft:gold_nugget");
        prop.setComment("The debug item to use for right clicking on blocks and entities. Examples: minecraft:gold_nugget or minecraft:coal@1 for Charcoal (metadata 1)");
        debugItemNameBlocks = prop.getString();
        debugItemBlocks = Configs.getDebugItem(debugItemNameBlocks);
        prop = conf.get(CATEGORY_GENERIC, "debugItemNameItems", "minecraft:blaze_rod");
        prop.setComment("The debug item to use for right clicking with to dump item NBT");
        debugItemNameItems = prop.getString();
        debugItemItems = Configs.getDebugItem(debugItemNameItems);
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    private static ItemStack getDebugItem(String nameIn) {
        String name = nameIn;
        int meta = 0;
        try {
            Pattern pattern = Pattern.compile("([a-zA-Z0-9_\\.-]+:[a-zA-Z0-9_\\.-]+)(?:@([0-9]+))?");
            Matcher matcher = pattern.matcher(nameIn);
            if (matcher.matches()) {
                name = matcher.group(1);
                String metaStr = matcher.group(2);
                if (metaStr != null) {
                    meta = Integer.parseInt(metaStr);
                }
            } else {
                TellMe.logger.warn("Invalid syntax for debug item name '{}'", (Object)nameIn);
            }
        }
        catch (NumberFormatException | PatternSyntaxException e) {
            TellMe.logger.warn("Failed to parse debug item name '{}'", (Object)nameIn, (Object)e);
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
        return item != null ? new ItemStack(item, 1, meta) : ItemStack.field_190927_a;
    }
}

