/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.datadump.DataDump;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityDump
extends DataDump {
    private EntityDump(DataDump.Format format) {
        super(4, format);
    }

    public static List<String> getFormattedEntityDump(DataDump.Format format) {
        EntityDump entityDump = new EntityDump(format);
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            Class clazz = ((EntityEntry)entry.getValue()).getEntityClass();
            String className = clazz.getSimpleName();
            EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(clazz, true);
            if (er != null) {
                entityDump.addData(er.getContainer().getName(), er.getRegistryName().toString(), className, String.valueOf(er.getModEntityId()));
                continue;
            }
            entityDump.addData("Minecraft", ((ResourceLocation)entry.getKey()).toString(), className, String.valueOf(EntityList.getID((Class)clazz)));
        }
        entityDump.addTitle("Mod name", "Registry name", "Entity class name", "ID");
        entityDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        entityDump.setUseColumnSeparator(true);
        return entityDump.getLines();
    }
}

