/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.datadump.DataDump;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidRegistryDump
extends DataDump {
    private FluidRegistryDump(DataDump.Format format) {
        super(8, format);
    }

    public static List<String> getFormattedFluidRegistryDump(DataDump.Format format) {
        FluidRegistryDump fluidRegistryDump = new FluidRegistryDump(format);
        for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
            Fluid fluid = (Fluid)entry.getValue();
            String name = (String)entry.getKey();
            String density = String.valueOf(fluid.getDensity());
            String temp = String.valueOf(fluid.getTemperature());
            String viscosity = String.valueOf(fluid.getViscosity());
            String luminosity = String.valueOf(fluid.getLuminosity());
            String isGaseous = String.valueOf(fluid.isGaseous());
            String rarity = fluid.getRarity().toString();
            String block = fluid.getBlock() != null ? fluid.getBlock().getRegistryName().toString() : "-";
            fluidRegistryDump.addData(name, density, temp, viscosity, luminosity, rarity, isGaseous, block);
        }
        fluidRegistryDump.addTitle("Name", "Density", "Temperature", "Viscosity", "Luminosity", "Rarity", "isGaseous", "Block");
        fluidRegistryDump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
        fluidRegistryDump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
        fluidRegistryDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        fluidRegistryDump.setColumnProperties(4, DataDump.Alignment.RIGHT, true);
        fluidRegistryDump.setColumnAlignment(6, DataDump.Alignment.RIGHT);
        fluidRegistryDump.setUseColumnSeparator(true);
        return fluidRegistryDump.getLines();
    }
}

