/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.ItemDump;
import fi.dy.masa.tellme.util.ModNameUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FoodItemDump {
    private static void addData(DataDump dump, ItemFood item, ResourceLocation rl, boolean hasSubTypes, @Nonnull ItemStack stack) {
        int id = Item.func_150891_b((Item)item);
        int meta = !stack.func_190926_b() ? stack.func_77960_j() : 0;
        String modName = ModNameUtils.getModName(rl);
        String registryName = rl.toString();
        String displayName = !stack.func_190926_b() ? stack.func_82833_r() : "";
        displayName = TextFormatting.func_110646_a((String)displayName);
        String hunger = !stack.func_190926_b() ? String.valueOf(item.func_150905_g(stack)) : "?";
        String saturation = !stack.func_190926_b() ? String.valueOf(item.func_150906_h(stack)) : "?";
        dump.addData(modName, registryName, String.valueOf(id), String.valueOf(meta), String.valueOf(hasSubTypes), displayName, hunger, saturation, ItemDump.getOredictKeysJoined(stack));
    }

    public static List<String> getFormattedFoodItemDump(DataDump.Format format) {
        DataDump itemDump = new DataDump(9, format);
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            Item item = (Item)entry.getValue();
            if (!(item instanceof ItemFood)) continue;
            FoodItemDump.getDataForItemSubtypes(itemDump, (ItemFood)item, (ResourceLocation)entry.getKey());
        }
        itemDump.addTitle("Mod name", "Registry name", "Item ID", "Meta/dmg", "Subtypes", "Display name", "Hunger", "Saturation", "Ore Dict keys");
        itemDump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
        itemDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        itemDump.setColumnAlignment(4, DataDump.Alignment.RIGHT);
        itemDump.setColumnProperties(6, DataDump.Alignment.RIGHT, true);
        itemDump.setColumnProperties(7, DataDump.Alignment.RIGHT, true);
        itemDump.setUseColumnSeparator(true);
        itemDump.addHeader("*** WARNING ***");
        itemDump.addHeader("The block and item IDs are dynamic and will be different on each world!");
        itemDump.addHeader("DO NOT use them for anything \"proper\"!! (other than manual editing/fixing of raw world data or something)");
        itemDump.addHeader("*** ALSO ***");
        itemDump.addHeader("The server doesn't have a list of sub block and sub items");
        itemDump.addHeader("(= items with different damage value or blocks with different metadata).");
        itemDump.addHeader("That is why the block and item list dumps only contain one entry per block/item class (separate ID) when run on a server.");
        return itemDump.getLines();
    }

    public static void getDataForItemSubtypes(DataDump itemDump, ItemFood item, ResourceLocation rl) {
        if (item.func_77614_k()) {
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab == null) continue;
                NonNullList stacks = NonNullList.func_191196_a();
                item.func_150895_a(tab, stacks);
                for (ItemStack stack : stacks) {
                    FoodItemDump.addData(itemDump, item, rl, true, stack);
                }
            }
        } else {
            FoodItemDump.addData(itemDump, item, rl, false, new ItemStack((Item)item, 1, 0));
        }
    }
}

