/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.BlockDump;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.ModNameUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDump {
    public static final String[] HARVEST_LEVEL_NAMES = new String[]{"Wood/Gold", "Stone", "Iron", "Diamond"};

    private static void addData(DataDump dump, Item item, ResourceLocation rl, boolean hasSubTypes, boolean includeToolClass, boolean dumpNBT, @Nonnull ItemStack stack) {
        int id = Item.func_150891_b((Item)item);
        int meta = !stack.func_190926_b() ? stack.func_77960_j() : 0;
        String modName = ModNameUtils.getModName(rl);
        String registryName = rl.toString();
        String displayName = !stack.func_190926_b() ? stack.func_82833_r() : "";
        displayName = TextFormatting.func_110646_a((String)displayName);
        if (includeToolClass) {
            Set toolClasses = item.getToolClasses(stack);
            String toolClassesStr = "";
            String harvestLevelStr = "";
            if (!toolClasses.isEmpty()) {
                ArrayList<String> classes = new ArrayList<String>();
                classes.addAll(toolClasses);
                Collections.sort(classes);
                toolClassesStr = String.join((CharSequence)", ", classes);
                for (int i = 0; i < classes.size(); ++i) {
                    String c = (String)classes.get(i);
                    int harvestLevel = item.getHarvestLevel(stack, c, null, null);
                    String hlName = harvestLevel >= 0 && harvestLevel < HARVEST_LEVEL_NAMES.length ? HARVEST_LEVEL_NAMES[harvestLevel] : "?";
                    classes.set(i, String.format("%s = %d (%s)", c, harvestLevel, hlName));
                }
                harvestLevelStr = String.join((CharSequence)", ", classes);
            }
            if (dumpNBT) {
                String nbt = !stack.func_190926_b() && stack.func_77978_p() != null ? stack.func_77978_p().toString() : "";
                dump.addData(modName, registryName, String.valueOf(id), String.valueOf(meta), String.valueOf(hasSubTypes), displayName, toolClassesStr, harvestLevelStr, ItemDump.getOredictKeysJoined(stack), nbt);
            } else {
                dump.addData(modName, registryName, String.valueOf(id), String.valueOf(meta), String.valueOf(hasSubTypes), displayName, toolClassesStr, harvestLevelStr, ItemDump.getOredictKeysJoined(stack));
            }
        } else if (dumpNBT) {
            String nbt = !stack.func_190926_b() && stack.func_77978_p() != null ? stack.func_77978_p().toString() : "";
            dump.addData(modName, registryName, String.valueOf(id), String.valueOf(meta), String.valueOf(hasSubTypes), displayName, ItemDump.getOredictKeysJoined(stack), nbt);
        } else {
            dump.addData(modName, registryName, String.valueOf(id), String.valueOf(meta), String.valueOf(hasSubTypes), displayName, ItemDump.getOredictKeysJoined(stack));
        }
    }

    public static List<String> getFormattedItemDump(DataDump.Format format, boolean includeToolClass, boolean dumpNBT) {
        int columnCount = 7;
        if (includeToolClass) {
            columnCount += 2;
        }
        if (dumpNBT) {
            ++columnCount;
        }
        DataDump itemDump = new DataDump(columnCount, format);
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            ItemDump.getDataForItemSubtypes(itemDump, (Item)entry.getValue(), (ResourceLocation)entry.getKey(), includeToolClass, dumpNBT);
        }
        if (includeToolClass) {
            if (dumpNBT) {
                itemDump.addTitle("Mod name", "Registry name", "Item ID", "Meta/dmg", "Subtypes", "Display name", "Tool classes", "Harvest levels", "Ore Dict keys", "NBT");
            } else {
                itemDump.addTitle("Mod name", "Registry name", "Item ID", "Meta/dmg", "Subtypes", "Display name", "Tool classes", "Harvest levels", "Ore Dict keys");
            }
        } else if (dumpNBT) {
            itemDump.addTitle("Mod name", "Registry name", "Item ID", "Meta/dmg", "Subtypes", "Display name", "Ore Dict keys", "NBT");
        } else {
            itemDump.addTitle("Mod name", "Registry name", "Item ID", "Meta/dmg", "Subtypes", "Display name", "Ore Dict keys");
        }
        itemDump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
        itemDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        itemDump.setColumnAlignment(4, DataDump.Alignment.RIGHT);
        itemDump.setUseColumnSeparator(true);
        itemDump.addHeader("*** WARNING ***");
        itemDump.addHeader("The block and item IDs are dynamic and will be different on each world!");
        itemDump.addHeader("DO NOT use them for anything \"proper\"!! (other than manual editing/fixing of raw world data or something)");
        itemDump.addHeader("*** ALSO ***");
        itemDump.addHeader("The server doesn't have a list of sub block and sub items");
        itemDump.addHeader("(= items with different damage value or blocks with different metadata).");
        itemDump.addHeader("That is why the block and item list dumps only contain one entry per block/item class (separate ID) when run on a server.");
        return itemDump.getLines();
    }

    private static void getDataForItemSubtypes(DataDump itemDump, Item item, ResourceLocation rl, boolean includeToolClass, boolean dumpNBT) {
        if (item.func_77614_k()) {
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab == null) continue;
                NonNullList stacks = NonNullList.func_191196_a();
                item.func_150895_a(tab, stacks);
                for (ItemStack stack : stacks) {
                    ItemDump.addData(itemDump, item, rl, true, includeToolClass, dumpNBT, stack);
                }
            }
        } else {
            ItemDump.addData(itemDump, item, rl, false, includeToolClass, dumpNBT, new ItemStack(item, 1, 0));
        }
    }

    public static String getJsonItemsWithPropsDump(EntityPlayer player) {
        HashMultimap map = HashMultimap.create((int)10000, (int)16);
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            ResourceLocation key = (ResourceLocation)entry.getKey();
            map.put((Object)key.func_110624_b(), (Object)key);
        }
        ArrayList mods = Lists.newArrayList((Iterable)map.keySet());
        Collections.sort(mods);
        JsonObject root = new JsonObject();
        for (String mod : mods) {
            ArrayList items = Lists.newArrayList((Iterable)map.get((Object)mod));
            Collections.sort(items);
            JsonObject objectMod = new JsonObject();
            for (ResourceLocation key : items) {
                JsonArray arrItem = new JsonArray();
                ItemDump.getDataForItemSubtypesForJson(arrItem, (Item)ForgeRegistries.ITEMS.getValue(key), key, player);
                objectMod.add(key.toString(), (JsonElement)arrItem);
            }
            root.add(ModNameUtils.getModName((ResourceLocation)items.get(0)), (JsonElement)objectMod);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)root);
    }

    public static String getOredictKeysJoined(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return "";
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids.length == 0) {
            return "";
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int id : ids) {
            names.add(OreDictionary.getOreName((int)id));
        }
        if (names.size() == 1) {
            return (String)names.get(0);
        }
        Collections.sort(names);
        return String.join((CharSequence)",", names);
    }

    public static String getStackInfoBasic(ItemStack stack) {
        if (!stack.func_190926_b()) {
            int meta = stack.func_77960_j();
            ResourceLocation rl = stack.func_77973_b().getRegistryName();
            String regName = rl != null ? rl.toString() : "<null>";
            String displayName = meta == Short.MAX_VALUE ? "(WILDCARD)" : stack.func_82833_r();
            displayName = TextFormatting.func_110646_a((String)displayName);
            return String.format("[%s@%d - '%s']", regName, meta, displayName);
        }
        return "";
    }

    public static String getStackInfo(ItemStack stack) {
        if (!stack.func_190926_b()) {
            int meta = stack.func_77960_j();
            ResourceLocation rl = stack.func_77973_b().getRegistryName();
            String regName = rl != null ? rl.toString() : "<null>";
            String displayName = meta == Short.MAX_VALUE ? "(WILDCARD)" : stack.func_82833_r();
            displayName = TextFormatting.func_110646_a((String)displayName);
            return String.format("[%s@%d - '%s' - %s]", regName, meta, displayName, stack.func_77978_p() != null ? stack.func_77978_p().toString() : "<no NBT>");
        }
        return "";
    }

    private static void getDataForItemSubtypesForJson(JsonArray arr, Item item, ResourceLocation rl, EntityPlayer player) {
        if (item.func_77614_k()) {
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab == null) continue;
                NonNullList stacks = NonNullList.func_191196_a();
                item.func_150895_a(tab, stacks);
                for (ItemStack stack : stacks) {
                    ItemDump.addDataForItemSubtypeForJson(arr, item, rl, true, stack, player);
                }
            }
        } else {
            ItemDump.addDataForItemSubtypeForJson(arr, item, rl, false, new ItemStack(item, 1, 0), player);
        }
    }

    private static void addDataForItemSubtypeForJson(JsonArray arr, Item item, ResourceLocation rl, boolean hasSubTypes, ItemStack stack, EntityPlayer player) {
        int itemId = Item.func_150891_b((Item)item);
        int itemMeta = stack.func_77960_j();
        int maxDamage = stack.func_77958_k();
        String subTypes = hasSubTypes ? String.valueOf(hasSubTypes) : "?";
        String exists = DataDump.isDummied(ForgeRegistries.ITEMS, rl) ? "false" : "true";
        String oreDictKeys = ItemDump.getOredictKeysJoined(stack);
        String itemName = item.getRegistryName().toString();
        String displayName = !stack.func_190926_b() ? stack.func_82833_r() : item.func_77667_c(stack);
        displayName = TextFormatting.func_110646_a((String)displayName);
        JsonObject obj = new JsonObject();
        obj.add("RegistryName", (JsonElement)new JsonPrimitive(itemName));
        obj.add("ItemID", (JsonElement)new JsonPrimitive((Number)itemId));
        obj.add("ItemMeta", (JsonElement)new JsonPrimitive((Number)itemMeta));
        obj.add("MaxStackSize", (JsonElement)new JsonPrimitive((Number)stack.func_77976_d()));
        if (maxDamage > 0) {
            obj.add("MaxDurability", (JsonElement)new JsonPrimitive((Number)maxDamage));
        }
        obj.add("SubTypes", (JsonElement)new JsonPrimitive(subTypes));
        obj.add("Exists", (JsonElement)new JsonPrimitive(exists));
        obj.add("DisplayName", (JsonElement)new JsonPrimitive(displayName));
        TellMe.proxy.addCreativeTabNames(obj, item);
        if (item instanceof ItemBlock) {
            try {
                World world = player.func_130014_f_();
                BlockPos pos = BlockPos.field_177992_a;
                ItemStack stackBefore = player.func_184614_ca();
                Block block = ((ItemBlock)item).func_179223_d();
                IBlockState state = block.func_176223_P();
                try {
                    ItemDump.setHeldItemWithoutEquipSound(player, EnumHand.MAIN_HAND, stack);
                    state = block.getStateForPlacement(world, pos, EnumFacing.UP, 0.5f, 1.0f, 0.5f, itemMeta, (EntityLivingBase)player, EnumHand.MAIN_HAND);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ItemDump.setHeldItemWithoutEquipSound(player, EnumHand.MAIN_HAND, stackBefore);
                String hardness = String.format("%.2f", BlockDump.field_blockHardness.get(block));
                String resistance = String.format("%.2f", BlockDump.field_blockResistance.get(block));
                String tool = block.getHarvestTool(state);
                int harvestLevel = block.getHarvestLevel(state);
                String harvestLevelName = harvestLevel >= 0 && harvestLevel < HARVEST_LEVEL_NAMES.length ? HARVEST_LEVEL_NAMES[harvestLevel] : "Unknown";
                boolean fallingBlock = block instanceof BlockFalling;
                int light = state.func_185906_d();
                boolean flammable = block.getFlammability((IBlockAccess)world, pos, EnumFacing.UP) > 0;
                int opacity = state.func_185891_c();
                obj.add("Type", (JsonElement)new JsonPrimitive("block"));
                obj.add("Hardness", (JsonElement)new JsonPrimitive(hardness));
                obj.add("Resistance", (JsonElement)new JsonPrimitive(resistance));
                obj.add("LightValue", (JsonElement)new JsonPrimitive((Number)light));
                obj.add("LightOpacity", (JsonElement)new JsonPrimitive((Number)opacity));
                obj.add("Flammable", (JsonElement)new JsonPrimitive(Boolean.valueOf(flammable)));
                obj.add("HarvestTool", (JsonElement)new JsonPrimitive(tool));
                obj.add("HarvestLevel", (JsonElement)new JsonPrimitive((Number)harvestLevel));
                obj.add("HarvestLevelName", (JsonElement)new JsonPrimitive(harvestLevelName));
                obj.add("FallingBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(fallingBlock)));
            }
            catch (Exception world) {}
        } else if (item instanceof ItemFood) {
            ItemFood itemFood = (ItemFood)item;
            String hunger = !stack.func_190926_b() ? String.valueOf(itemFood.func_150905_g(stack)) : "?";
            String saturation = !stack.func_190926_b() ? String.valueOf(itemFood.func_150906_h(stack)) : "?";
            obj.add("Type", (JsonElement)new JsonPrimitive("food"));
            obj.add("Hunger", (JsonElement)new JsonPrimitive(hunger));
            obj.add("Saturation", (JsonElement)new JsonPrimitive(saturation));
        } else {
            Multimap attributes;
            obj.add("Type", (JsonElement)new JsonPrimitive("generic"));
            ArrayList toolClasses = new ArrayList(item.getToolClasses(stack));
            if (!toolClasses.isEmpty()) {
                StringBuilder levels = new StringBuilder(32);
                levels.append(String.valueOf(item.getHarvestLevel(stack, (String)toolClasses.get(0), null, null)));
                for (int i = 1; i < toolClasses.size(); ++i) {
                    levels.append(",").append(item.getHarvestLevel(stack, (String)toolClasses.get(i), null, null));
                }
                obj.add("ToolClasses", (JsonElement)new JsonPrimitive(String.join((CharSequence)",", toolClasses)));
                obj.add("HarvestLevels", (JsonElement)new JsonPrimitive(levels.toString()));
                if (item instanceof ItemTool) {
                    obj.add("ToolMaterial", (JsonElement)new JsonPrimitive(((ItemTool)item).func_77861_e()));
                }
            }
            if (!(attributes = item.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack)).isEmpty()) {
                JsonArray attributeArr = new JsonArray();
                for (Map.Entry entry : attributes.entries()) {
                    JsonObject o1 = new JsonObject();
                    JsonObject o2 = new JsonObject();
                    o1.add("Type", (JsonElement)new JsonPrimitive((String)entry.getKey()));
                    o1.add("Value", (JsonElement)o2);
                    AttributeModifier att = (AttributeModifier)entry.getValue();
                    o2.add("Name", (JsonElement)new JsonPrimitive(att.func_111166_b()));
                    o2.add("Operation", (JsonElement)new JsonPrimitive((Number)att.func_111169_c()));
                    o2.add("Amount", (JsonElement)new JsonPrimitive((Number)att.func_111164_d()));
                    attributeArr.add((JsonElement)o1);
                }
                obj.add("Attributes", (JsonElement)attributeArr);
            }
        }
        obj.add("OreDict", (JsonElement)new JsonPrimitive(oreDictKeys));
        arr.add((JsonElement)obj);
    }

    public static void setHeldItemWithoutEquipSound(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
        } else if (hand == EnumHand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)stack);
        }
    }
}

