/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.ModNameUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PotionDump
extends DataDump {
    private static final Field field_isBeneficial = ObfuscationReflectionHelper.findField(Potion.class, (String)"field_188415_h");

    private PotionDump(DataDump.Format format) {
        super(7, format);
    }

    public static List<String> getFormattedPotionDump(DataDump.Format format) {
        PotionDump potionDump = new PotionDump(format);
        for (Map.Entry entry : ForgeRegistries.POTIONS.getEntries()) {
            Potion potion = (Potion)entry.getValue();
            ResourceLocation rl = (ResourceLocation)entry.getKey();
            String modName = ModNameUtils.getModName(rl);
            String regName = rl.toString();
            String id = String.valueOf(Potion.func_188409_a((Potion)potion));
            String name = potion.func_76393_a();
            String color = String.format("0x%08X (%10d)", potion.func_76401_j(), potion.func_76401_j());
            String isBad = String.valueOf(potion.func_76398_f());
            String isBeneficial = PotionDump.getIsBeneficial(potion);
            potionDump.addData(modName, regName, name, id, color, isBad, isBeneficial);
        }
        potionDump.addTitle("Mod name", "Registry name", "Potion Name", "ID", "Liquid color", "Is bad", "Is beneficial");
        potionDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        potionDump.setColumnAlignment(5, DataDump.Alignment.RIGHT);
        potionDump.setColumnAlignment(6, DataDump.Alignment.RIGHT);
        potionDump.setUseColumnSeparator(true);
        return potionDump.getLines();
    }

    public static String getIsBeneficial(Potion potion) {
        try {
            return String.valueOf(field_isBeneficial.get(potion));
        }
        catch (Exception e) {
            TellMe.logger.warn("Failed to reflect Potion#beneficial", (Throwable)e);
            return "";
        }
    }
}

