/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.event;

import fi.dy.masa.tellme.config.Configs;
import fi.dy.masa.tellme.util.BlockInfo;
import fi.dy.masa.tellme.util.EntityInfo;
import fi.dy.masa.tellme.util.ItemInfo;
import fi.dy.masa.tellme.util.RayTraceUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class InteractEventHandler {
    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        this.printBlockInfo((PlayerInteractEvent)event, false);
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (Configs.enableDebugItemForItems && !event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND && player.func_70003_b(4, "tellme")) {
            if (ItemInfo.areItemStacksEqual(Configs.debugItemItems, player.func_184614_ca())) {
                this.printItemInfo(event.getEntityPlayer());
            } else if (ItemInfo.areItemStacksEqual(Configs.debugItemBlocks, player.func_184614_ca())) {
                this.printBlockInfo((PlayerInteractEvent)event, true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        this.printEntityInfo((PlayerInteractEvent)event, event.getTarget());
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        this.printEntityInfo((PlayerInteractEvent)event, event.getTarget());
    }

    private void printEntityInfo(PlayerInteractEvent event, Entity entity) {
        EntityPlayer player = event.getEntityPlayer();
        if (Configs.enableDebugItemForBlockAndEntities && event.getHand() == EnumHand.MAIN_HAND && player.func_70003_b(4, "tellme") && ItemInfo.areItemStacksEqual(Configs.debugItemBlocks, player.func_184614_ca())) {
            if (!event.getWorld().field_72995_K) {
                EntityInfo.printEntityInfo(player, entity, player.func_70093_af());
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    private void printBlockInfo(PlayerInteractEvent event, boolean useLiquids) {
        EntityPlayer player = event.getEntityPlayer();
        if (Configs.enableDebugItemForBlockAndEntities && event.getHand() == EnumHand.MAIN_HAND && player.func_70003_b(4, "tellme") && ItemInfo.areItemStacksEqual(Configs.debugItemBlocks, player.func_184614_ca())) {
            if (!event.getWorld().field_72995_K) {
                BlockInfo.getBlockInfoFromRayTracedTarget(event.getWorld(), player, RayTraceUtils.getRayTraceFromEntity(event.getWorld(), (Entity)player, useLiquids), ItemInfo.areItemStacksEqual(Configs.debugItemBlocks, player.func_184592_cb()), player.func_70093_af());
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    private void printItemInfo(EntityPlayer player) {
        int slot = player.field_71071_by.field_70461_c;
        if (slot >= 0 && slot <= 7) {
            ++slot;
        } else if (slot == 8) {
            slot = 0;
        } else {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70301_a(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() != null) {
            ItemInfo.printItemInfo(player, stack, player.func_70093_af());
        }
    }
}

