/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.network;

import fi.dy.masa.tellme.TellMe;
import io.netty.buffer.ByteBuf;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageCopyToClipboard
implements IMessage {
    private String str;

    public MessageCopyToClipboard() {
    }

    public MessageCopyToClipboard(String str) {
        this.str = str;
    }

    public void fromBytes(ByteBuf buf) {
        this.str = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.str);
    }

    public static class Handler
    implements IMessageHandler<MessageCopyToClipboard, IMessage> {
        public IMessage onMessage(final MessageCopyToClipboard message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                TellMe.logger.error("Wrong side in MessageCopyToClipboard: " + ctx.side);
                return null;
            }
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc == null) {
                TellMe.logger.error("Minecraft was null in MessageCopyToClipboard");
                return null;
            }
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message);
                }
            });
            return null;
        }

        protected void processMessage(MessageCopyToClipboard message) {
            if (Desktop.isDesktopSupported()) {
                StringSelection stringSelection = new StringSelection(message.str);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
                FMLClientHandler.instance().getClient().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Copied " + message.str), true);
            }
        }
    }
}

