/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util;

import com.google.common.base.Optional;
import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.ChatUtils;
import fi.dy.masa.tellme.util.NBTFormatter;
import fi.dy.masa.tellme.util.RayTraceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class BlockInfo {
    public static <T extends Comparable<T>> IBlockState setPropertyValueFromString(IBlockState state, IProperty<T> prop, String valueStr) {
        Optional value = prop.func_185929_b(valueStr);
        if (value.isPresent()) {
            return state.func_177226_a(prop, (Comparable)value.get());
        }
        return state;
    }

    public static <T extends Comparable<T>> List<IBlockState> getFilteredStates(Collection<IBlockState> initialStates, String propName, String propValue) {
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        for (IBlockState state : initialStates) {
            Optional value;
            IProperty prop = state.func_177230_c().func_176194_O().func_185920_a(propName);
            if (prop == null || !(value = prop.func_185929_b(propValue)).isPresent() || !state.func_177229_b(prop).equals(value.get())) continue;
            list.add(state);
        }
        return list;
    }

    public static List<Pair<String, String>> getProperties(String blockName) {
        ArrayList<Pair<String, String>> props = new ArrayList<Pair<String, String>>();
        Pattern patternNameProps = Pattern.compile("(?<name>([a-z0-9_]+:)?[a-z0-9\\._]+)\\[(?<props>[a-z0-9_]+=[a-z0-9_]+(,[a-z0-9_]+=[a-z0-9_]+)*)\\]");
        Matcher matcherNameProps = patternNameProps.matcher(blockName);
        if (matcherNameProps.matches()) {
            String propStr = matcherNameProps.group("props");
            String[] propParts = propStr.split(",");
            Pattern patternProp = Pattern.compile("(?<prop>[a-zA-Z0-9\\._-]+)=(?<value>[a-zA-Z0-9\\._-]+)");
            for (int i = 0; i < propParts.length; ++i) {
                Matcher matcherProp = patternProp.matcher(propParts[i]);
                if (matcherProp.matches()) {
                    props.add((Pair<String, String>)Pair.of((Object)matcherProp.group("prop"), (Object)matcherProp.group("value")));
                    continue;
                }
                TellMe.logger.warn("Invalid block property '{}'", (Object)propParts[i]);
            }
            Collections.sort(props);
        }
        return props;
    }

    private static String getTileInfo(World world, BlockPos pos) {
        boolean shouldHaveTE;
        String teInfo = "";
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        boolean teInWorld = world.func_175625_s(pos) != null;
        teInfo = teInWorld == (shouldHaveTE = state.func_177230_c().hasTileEntity(state)) ? (teInWorld ? "has a TileEntity" : "no TileEntity") : (teInWorld ? "!! is not supposed to have a TileEntity, but there is one in the world !!" : "!! is supposed to have a TileEntity, but there isn't one in the world !!");
        return teInfo;
    }

    private static List<String> getFullBlockInfo(EntityPlayer player, World world, BlockPos pos) {
        ArrayList<String> lines = new ArrayList<String>();
        BlockData data = BlockData.getFor(world, pos, player);
        lines.add(data.toString());
        IBlockState state = data.actualState;
        lines.add(String.format("Full block state: %s", state));
        lines.add(String.format("Hardness: %.4f, Explosion resistance: %.4f, Material: %s", Float.valueOf(state.func_185887_b(world, pos)), Float.valueOf(state.func_177230_c().getExplosionResistance(world, pos, null, new Explosion(world, null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2.0f, true, true))), BlockInfo.getMaterialName(state.func_185904_a())));
        lines.add("Block class: " + state.func_177230_c().getClass().getName());
        if (state.func_177228_b().size() > 0) {
            lines.add("IBlockState properties, including getActualState():");
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                lines.add(((IProperty)entry.getKey()).toString() + ": " + ((Comparable)entry.getValue()).toString());
            }
        } else {
            lines.add("IBlockState properties: <none>");
        }
        TellMe.proxy.getExtendedBlockStateInfo(world, state, pos, lines);
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            te.func_189515_b(nbt);
            lines.add("TileEntity class: " + te.getClass().getName());
            lines.add("");
            lines.add("TileEntity NBT (from TileEntity#writeToNBT()):");
            NBTFormatter.getPrettyFormattedNBT(lines, nbt);
        }
        return lines;
    }

    public static String getMaterialName(Material material) {
        if (material == Material.field_151579_a) {
            return "AIR";
        }
        if (material == Material.field_151577_b) {
            return "GRASS";
        }
        if (material == Material.field_151578_c) {
            return "GROUND";
        }
        if (material == Material.field_151575_d) {
            return "WOOD";
        }
        if (material == Material.field_151576_e) {
            return "ROCK";
        }
        if (material == Material.field_151573_f) {
            return "IRON";
        }
        if (material == Material.field_151574_g) {
            return "ANVIL";
        }
        if (material == Material.field_151586_h) {
            return "WATER";
        }
        if (material == Material.field_151587_i) {
            return "LAVA";
        }
        if (material == Material.field_151584_j) {
            return "LEAVES";
        }
        if (material == Material.field_151585_k) {
            return "PLANTS";
        }
        if (material == Material.field_151582_l) {
            return "VINE";
        }
        if (material == Material.field_151583_m) {
            return "SPONGE";
        }
        if (material == Material.field_151580_n) {
            return "CLOTH";
        }
        if (material == Material.field_151581_o) {
            return "FIRE";
        }
        if (material == Material.field_151595_p) {
            return "SAND";
        }
        if (material == Material.field_151594_q) {
            return "CIRCUITS";
        }
        if (material == Material.field_151593_r) {
            return "CARPET";
        }
        if (material == Material.field_151592_s) {
            return "GLASS";
        }
        if (material == Material.field_151591_t) {
            return "REDSTONE_LIGHT";
        }
        if (material == Material.field_151590_u) {
            return "TNT";
        }
        if (material == Material.field_151589_v) {
            return "CORAL";
        }
        if (material == Material.field_151588_w) {
            return "ICE";
        }
        if (material == Material.field_151598_x) {
            return "PACKED_ICE";
        }
        if (material == Material.field_151597_y) {
            return "SNOW";
        }
        if (material == Material.field_151596_z) {
            return "CRAFTED_SNOW";
        }
        if (material == Material.field_151570_A) {
            return "CACTUS";
        }
        if (material == Material.field_151571_B) {
            return "CLAY";
        }
        if (material == Material.field_151572_C) {
            return "GOURD";
        }
        if (material == Material.field_151566_D) {
            return "DRAGON_EGG";
        }
        if (material == Material.field_151567_E) {
            return "PORTAL";
        }
        if (material == Material.field_151568_F) {
            return "CAKE";
        }
        if (material == Material.field_151569_G) {
            return "WEB";
        }
        if (material == Material.field_76233_E) {
            return "PISTON";
        }
        if (material == Material.field_175972_I) {
            return "BARRIER";
        }
        if (material == Material.field_189963_J) {
            return "STRUCTURE_VOID";
        }
        return "unknown";
    }

    public static void printBasicBlockInfoToChat(EntityPlayer player, World world, BlockPos pos) {
        player.func_145747_a(BlockData.getFor(world, pos, player).toChatMessage());
    }

    public static void printBlockInfoToConsole(EntityPlayer player, World world, BlockPos pos) {
        List<String> lines = BlockInfo.getFullBlockInfo(player, world, pos);
        for (String line : lines) {
            TellMe.logger.info(line);
        }
    }

    public static void dumpBlockInfoToFile(EntityPlayer player, World world, BlockPos pos) {
        File file = DataDump.dumpDataToFile("block_and_tileentity_data", BlockInfo.getFullBlockInfo(player, world, pos));
        SubCommand.sendClickableLinkMessage((ICommandSender)player, "Output written to file %s", file);
    }

    public static void getBlockInfoFromRayTracedTarget(World world, EntityPlayer player, RayTraceResult trace, boolean adjacent, boolean dumpToFile) {
        if (trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = adjacent ? trace.func_178782_a().func_177972_a(trace.field_178784_b) : trace.func_178782_a();
            BlockInfo.printBasicBlockInfoToChat(player, world, pos);
            if (dumpToFile) {
                BlockInfo.dumpBlockInfoToFile(player, world, pos);
            } else {
                BlockInfo.printBlockInfoToConsole(player, world, pos);
            }
        }
    }

    public static class BlockData {
        private final IBlockState actualState;
        private final String regName;
        private final int id;
        private final int meta;
        private final String displayName;
        private final String teInfo;

        public BlockData(IBlockState actualState, String displayName, String regName, int id, int meta, String teInfo) {
            this.actualState = actualState;
            this.displayName = displayName;
            this.regName = regName;
            this.id = id;
            this.meta = meta;
            this.teInfo = teInfo;
        }

        public static BlockData getFor(World world, BlockPos pos, EntityPlayer player) {
            IBlockState actualState = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
            Block block = actualState.func_177230_c();
            int id = Block.func_149682_b((Block)block);
            int meta = block.func_176201_c(actualState);
            ItemStack stack = block.getPickBlock(actualState, RayTraceUtils.getRayTraceFromEntity(world, (Entity)player, true), world, pos, player);
            ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            String registryName = rl != null ? rl.toString() : "<null>";
            String displayName = !stack.func_190926_b() ? stack.func_82833_r() : registryName;
            return new BlockData(actualState, displayName, registryName, id, meta, BlockInfo.getTileInfo(world, pos));
        }

        public ITextComponent toChatMessage() {
            String copyStr = this.meta != 0 ? this.regName + ":" + this.meta : this.regName;
            String textPre = String.format("%s (", this.displayName);
            String textPost = String.format(" - %d:%d) %s", this.id, this.meta, this.teInfo);
            return ChatUtils.getClipboardCopiableMessage(textPre, copyStr, textPost);
        }

        public String toString() {
            return String.format("%s (%s - %d:%d) %s", this.displayName, this.regName, this.id, this.meta, this.teInfo);
        }
    }
}

