/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.chunkprocessor.ChunkProcessorAllChunks;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockStats
extends ChunkProcessorAllChunks {
    private boolean append;
    private final Multimap<String, BlockInfo> blockStats = MultimapBuilder.hashKeys().arrayListValues().build();

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public void processChunks(Collection<Chunk> chunks, BlockPos posMin, BlockPos posMax) {
        Object2LongOpenHashMap counts = new Object2LongOpenHashMap();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        long timeBefore = System.currentTimeMillis();
        int count = 0;
        for (Chunk chunk : chunks) {
            int topY = chunk.func_76625_h() + 15;
            int xMin = Math.max(chunk.field_76635_g << 4, posMin.func_177958_n());
            int yMin = Math.max(0, posMin.func_177956_o());
            int zMin = Math.max(chunk.field_76647_h << 4, posMin.func_177952_p());
            int xMax = Math.min((chunk.field_76635_g << 4) + 15, posMax.func_177958_n());
            int yMax = Math.min(topY, posMax.func_177956_o());
            int zMax = Math.min((chunk.field_76647_h << 4) + 15, posMax.func_177952_p());
            for (int z = zMin; z <= zMax; ++z) {
                for (int x = xMin; x <= xMax; ++x) {
                    for (int y = yMin; y <= yMax; ++y) {
                        pos.func_181079_c(x, y, z);
                        IBlockState state = chunk.func_177435_g((BlockPos)pos);
                        counts.addTo((Object)state, 1L);
                        ++count;
                    }
                }
            }
            if (topY >= posMax.func_177956_o()) continue;
            counts.addTo((Object)Blocks.field_150350_a.func_176223_P(), (long)((posMax.func_177956_o() - topY) * 256));
        }
        long timeAfter = System.currentTimeMillis();
        TellMe.logger.info(String.format(Locale.US, "Counted %d blocks in %d chunks in %.3f seconds.", count, chunks.size(), Float.valueOf((float)(timeAfter - timeBefore) / 1000.0f)));
        this.addParsedData((Object2LongOpenHashMap<IBlockState>)counts);
    }

    private void addParsedData(Object2LongOpenHashMap<IBlockState> counts) {
        if (!this.append) {
            this.blockStats.clear();
        }
        for (IBlockState state : counts.keySet()) {
            try {
                Block block = state.func_177230_c();
                ResourceLocation key = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
                String registryName = key != null ? key.toString() : "null";
                int id = Block.func_149682_b((Block)block);
                int meta = block.func_176201_c(state);
                ItemStack stack = new ItemStack(block, 1, block.func_180651_a(state));
                String displayName = !stack.func_190926_b() ? stack.func_82833_r() : registryName;
                long amount = counts.getLong((Object)state);
                if (key == null) {
                    TellMe.logger.warn("Non-registered block: class = {}, id = {}, meta = {}, state 0 {}", (Object)block.getClass().getName(), (Object)id, (Object)meta, (Object)state);
                }
                if (this.append) {
                    boolean appended = false;
                    for (BlockInfo old : this.blockStats.get((Object)registryName)) {
                        if (old.id != id || old.meta != meta) continue;
                        old.addToCount(amount);
                        appended = true;
                        break;
                    }
                    if (appended) continue;
                    this.blockStats.put((Object)registryName, (Object)new BlockInfo(registryName, displayName, id, meta, amount));
                    continue;
                }
                this.blockStats.put((Object)registryName, (Object)new BlockInfo(registryName, displayName, id, meta, amount));
            }
            catch (Exception e) {
                TellMe.logger.error("Caught an exception while getting block names", (Throwable)e);
            }
        }
    }

    private List<BlockInfo> getFilteredData(DataDump dump, List<String> filters, boolean sortByCount) {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        for (String filter : filters) {
            int lastSemi;
            int firstSemi = filter.indexOf(":");
            if (firstSemi == -1) {
                filter = "minecraft:" + filter;
            }
            if ((lastSemi = filter.lastIndexOf(":")) != firstSemi && lastSemi < filter.length() - 1) {
                try {
                    int meta = Integer.parseInt(filter.substring(lastSemi + 1, filter.length()));
                    for (BlockInfo info : this.blockStats.get((Object)filter)) {
                        if (info.meta != meta) continue;
                        list.add(info);
                    }
                }
                catch (NumberFormatException e) {
                    TellMe.logger.error("Caught an exception while parsing block meta value from user input", (Throwable)e);
                }
                continue;
            }
            for (BlockInfo info : this.blockStats.get((Object)filter)) {
                list.add(info);
            }
        }
        return list;
    }

    public List<String> queryAll(DataDump.Format format, boolean sortByCount) {
        return this.query(format, null, sortByCount);
    }

    public List<String> query(DataDump.Format format, @Nullable List<String> filters, boolean sortByCount) {
        DataDump dump = new DataDump(5, format);
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        if (filters != null) {
            list.addAll(this.getFilteredData(dump, filters, sortByCount));
        } else {
            list.addAll(this.blockStats.values());
        }
        BlockInfo.setSortByCount(sortByCount);
        Collections.sort(list);
        for (BlockInfo info : list) {
            dump.addData(info.registryName, String.valueOf(info.id), String.valueOf(info.meta), info.displayName, String.valueOf(info.count));
        }
        dump.addTitle("Registry name", "ID", "meta", "Display name", "Count");
        dump.addHeader("NOTE: The Block ID is for very specific low-level purposes only!");
        dump.addHeader("It WILL be different in every world since Minecraft 1.7,");
        dump.addHeader("because they are dynamically allocated by the game!");
        dump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
        dump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
        dump.setColumnProperties(4, DataDump.Alignment.RIGHT, true);
        dump.setUseColumnSeparator(true);
        dump.setSort(!sortByCount);
        return dump.getLines();
    }

    private static class BlockInfo
    implements Comparable<BlockInfo> {
        private static boolean sortByCount = false;
        public final String registryName;
        public final String displayName;
        public final int id;
        public final int meta;
        public long count;

        public BlockInfo(String name, String displayName, int id, int meta, long count) {
            this.registryName = name;
            this.displayName = displayName;
            this.id = id;
            this.meta = meta;
            this.count = count;
        }

        public static void setSortByCount(boolean sortByCount) {
            BlockInfo.sortByCount = sortByCount;
        }

        public void addToCount(long amount) {
            this.count += amount;
        }

        @Override
        public int compareTo(BlockInfo other) {
            if (other == null) {
                throw new NullPointerException();
            }
            if (sortByCount) {
                return this.count > other.count ? -1 : (this.count < other.count ? 1 : this.registryName.compareTo(other.registryName));
            }
            int val = this.registryName.compareTo(other.registryName);
            if (val != 0) {
                return val;
            }
            if (this.id != other.id) {
                return this.id - other.id;
            }
            if (this.meta != other.meta) {
                return this.meta - other.meta;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + this.meta;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockInfo other = (BlockInfo)obj;
            if (this.id != other.id) {
                return false;
            }
            return this.meta == other.meta;
        }
    }
}

