/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import fi.dy.masa.tellme.datadump.EntityCountDump;
import fi.dy.masa.tellme.util.EntityInfo;
import fi.dy.masa.tellme.util.chunkprocessor.ChunkProcessorLoadedChunks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EntitiesPerTypeCounter
extends ChunkProcessorLoadedChunks {
    private Map<Class<? extends Entity>, Integer> perTypeCount = new HashMap<Class<? extends Entity>, Integer>();
    private int totalCount;

    @Override
    public void processChunk(Chunk chunk) {
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        int total = 0;
        for (int i = 0; i < entityLists.length; ++i) {
            Iterator iter = entityLists[i].iterator();
            total += entityLists[i].size();
            while (iter.hasNext()) {
                Entity entity = (Entity)iter.next();
                Integer countInt = this.perTypeCount.get(entity.getClass());
                int count = countInt != null ? countInt + 1 : 1;
                this.perTypeCount.put(entity.getClass(), count);
            }
        }
        if (total == 0) {
            ++this.chunksWithZeroCount;
        } else {
            this.totalCount += total;
        }
    }

    @Override
    public EntityCountDump createDump(World world) {
        ArrayList<ChunkProcessorLoadedChunks.EntitiesPerTypeHolder> counts = new ArrayList<ChunkProcessorLoadedChunks.EntitiesPerTypeHolder>();
        for (Class<? extends Entity> clazz : this.perTypeCount.keySet()) {
            counts.add(new ChunkProcessorLoadedChunks.EntitiesPerTypeHolder(clazz, this.perTypeCount.get(clazz)));
        }
        Collections.sort(counts);
        EntityCountDump dump = new EntityCountDump(2);
        dump.addTitle("Entity type", "Count");
        dump.addHeader("Loaded entities by entity type:");
        for (ChunkProcessorLoadedChunks.EntitiesPerTypeHolder holder : counts) {
            dump.addData(EntityInfo.getEntityNameFromClass(holder.clazz), String.valueOf(holder.count));
        }
        dump.addFooter(String.format("In total there were %d loaded entities in %d chunks.", this.totalCount, this.getLoadedChunkCount() - this.chunksWithZeroCount));
        return dump;
    }
}

