/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.TileEntityDump;
import fi.dy.masa.tellme.util.BlockInfo;
import fi.dy.masa.tellme.util.chunkprocessor.ChunkProcessorAllChunks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Locate
extends ChunkProcessorAllChunks {
    private final LocateType locateType;
    private final OutputType outputType;
    private final DataDump.Format format;
    private final Set<String> filters;
    private boolean printDimension;
    private List<LocationData> data = new ArrayList<LocationData>();

    private Locate(LocateType locateType, OutputType outputType, Set<String> filters) {
        this.locateType = locateType;
        this.outputType = outputType;
        this.filters = filters;
        this.format = outputType == OutputType.DUMP_CSV ? DataDump.Format.CSV : DataDump.Format.ASCII;
    }

    public static Locate create(LocateType locateType, OutputType outputType, Set<String> filters) {
        return new Locate(locateType, outputType, filters);
    }

    public Locate setPrintDimension(boolean printDimension) {
        this.printDimension = printDimension;
        return this;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public LocateType getLocateType() {
        return this.locateType;
    }

    private IdentityHashMap<IBlockState, Integer> generateBlockStateFilters() {
        int i = 0;
        IdentityHashMap<IBlockState, Integer> blockStateFilter = new IdentityHashMap<IBlockState, Integer>(this.filters.size() * 16);
        ResourceLocation air = new ResourceLocation("minecraft:air");
        for (String str : this.filters) {
            int index = str.indexOf(91);
            String name = index > 0 ? str.substring(0, index) : str;
            ResourceLocation key = new ResourceLocation(name);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
            if (block != null && (block != Blocks.field_150350_a || key.equals((Object)air))) {
                Object states = block.func_176194_O().func_177619_a();
                List<Pair<String, String>> props = BlockInfo.getProperties(str);
                if (!props.isEmpty()) {
                    for (Pair pair : props) {
                        states = BlockInfo.getFilteredStates((Collection<IBlockState>)states, (String)pair.getLeft(), (String)pair.getRight());
                    }
                }
                for (IBlockState iBlockState : states) {
                    blockStateFilter.put(iBlockState, i++);
                }
                continue;
            }
            TellMe.logger.warn("Invalid block name '{}'", (Object)str);
        }
        return blockStateFilter;
    }

    private Set<Class<? extends Entity>> generateEntityFilters() {
        HashSet<Class<? extends Entity>> set = new HashSet<Class<? extends Entity>>();
        for (String name : this.filters) {
            Class clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(name));
            if (clazz != null) {
                set.add(clazz);
                continue;
            }
            TellMe.logger.warn("Invalid entity name '{}'", (Object)name);
        }
        return set;
    }

    private Set<Class<? extends TileEntity>> generateTileEntityFilters() {
        HashSet<Class<? extends TileEntity>> set = new HashSet<Class<? extends TileEntity>>();
        for (String name : this.filters) {
            RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> registry = TileEntityDump.getTileEntityRegistry();
            Class clazz = (Class)registry.func_82594_a((Object)new ResourceLocation(name));
            if (clazz != null) {
                set.add(clazz);
                continue;
            }
            TellMe.logger.warn("Invalid TileEntity name '{}'", (Object)name);
        }
        return set;
    }

    @Override
    public void processChunks(Collection<Chunk> chunks, BlockPos posMin, BlockPos posMax) {
        switch (this.locateType) {
            case BLOCK: {
                this.locateBlocks(chunks, posMin, posMax, this.generateBlockStateFilters());
                break;
            }
            case ENTITY: {
                this.locateEntities(chunks, posMin, posMax, this.generateEntityFilters());
                break;
            }
            case TILE_ENTITY: {
                this.locateTileEntities(chunks, posMin, posMax, this.generateTileEntityFilters());
                break;
            }
        }
    }

    private void locateBlocks(Collection<Chunk> chunks, BlockPos posMin, BlockPos posMax, IdentityHashMap<IBlockState, Integer> filters) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        int count = 0;
        long timeBefore = System.currentTimeMillis();
        for (Chunk chunk : chunks) {
            if (this.data.size() >= 100000) {
                TellMe.logger.warn("Over 100 000 blocks found already, aborting...");
                break;
            }
            int dim = chunk.func_177412_p().field_73011_w.getDimension();
            int topY = chunk.func_76625_h() + 15;
            int xMin = Math.max(chunk.field_76635_g << 4, posMin.func_177958_n());
            int yMin = Math.max(0, posMin.func_177956_o());
            int zMin = Math.max(chunk.field_76647_h << 4, posMin.func_177952_p());
            int xMax = Math.min((chunk.field_76635_g << 4) + 15, posMax.func_177958_n());
            int yMax = Math.min(topY, posMax.func_177956_o());
            int zMax = Math.min((chunk.field_76647_h << 4) + 15, posMax.func_177952_p());
            for (int z = zMin; z <= zMax; ++z) {
                for (int x = xMin; x <= xMax; ++x) {
                    for (int y = yMin; y <= yMax; ++y) {
                        pos.func_181079_c(x, y, z);
                        IBlockState state = chunk.func_177435_g((BlockPos)pos);
                        if (!filters.containsKey(state)) continue;
                        this.data.add(LocationData.of(state.toString(), dim, new Vec3d((double)x, (double)y, (double)z)));
                        ++count;
                    }
                }
            }
        }
        long timeAfter = System.currentTimeMillis();
        TellMe.logger.info(String.format(Locale.US, "Located %d blocks in %d chunks in %.3f seconds.", count, chunks.size(), Float.valueOf((float)(timeAfter - timeBefore) / 1000.0f)));
    }

    private void locateEntities(Collection<Chunk> chunks, BlockPos posMin, BlockPos posMax, Set<Class<? extends Entity>> filters) {
        int count = 0;
        long timeBefore = System.currentTimeMillis();
        for (Chunk chunk : chunks) {
            int dim = chunk.func_177412_p().field_73011_w.getDimension();
            int xMin = Math.max(chunk.field_76635_g << 4, posMin.func_177958_n());
            int yMin = Math.max(0, posMin.func_177956_o());
            int zMin = Math.max(chunk.field_76647_h << 4, posMin.func_177952_p());
            int xMax = Math.min((chunk.field_76635_g << 4) + 16, posMax.func_177958_n());
            int yMax = Math.min(256, posMax.func_177956_o());
            int zMax = Math.min((chunk.field_76647_h << 4) + 16, posMax.func_177952_p());
            AxisAlignedBB bb = new AxisAlignedBB((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
            for (int i = 0; i < chunk.func_177429_s().length; ++i) {
                ClassInheritanceMultiMap map = chunk.func_177429_s()[i];
                for (Entity entity : map) {
                    if (!filters.contains(entity.getClass()) || !entity.func_174813_aQ().func_72326_a(bb)) continue;
                    ResourceLocation name = EntityList.func_191301_a((Entity)entity);
                    this.data.add(LocationData.of(name.toString(), dim, entity.func_174791_d()));
                    ++count;
                }
            }
        }
        long timeAfter = System.currentTimeMillis();
        TellMe.logger.info(String.format(Locale.US, "Located %d Entities in %d chunks in %.3f seconds.", count, chunks.size(), Float.valueOf((float)(timeAfter - timeBefore) / 1000.0f)));
    }

    private void locateTileEntities(Collection<Chunk> chunks, BlockPos posMin, BlockPos posMax, Set<Class<? extends TileEntity>> filters) {
        int count = 0;
        long timeBefore = System.currentTimeMillis();
        RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> registry = TileEntityDump.getTileEntityRegistry();
        for (Chunk chunk : chunks) {
            if (this.data.size() >= 100000) {
                TellMe.logger.warn("Over 100 000 TileEntities found already, aborting...");
                break;
            }
            int dim = chunk.func_177412_p().field_73011_w.getDimension();
            int topY = chunk.func_76625_h() + 15;
            int xMin = Math.max(chunk.field_76635_g << 4, posMin.func_177958_n());
            int yMin = Math.max(0, posMin.func_177956_o());
            int zMin = Math.max(chunk.field_76647_h << 4, posMin.func_177952_p());
            int xMax = Math.min((chunk.field_76635_g << 4) + 15, posMax.func_177958_n());
            int yMax = Math.min(topY, posMax.func_177956_o());
            int zMax = Math.min((chunk.field_76647_h << 4) + 15, posMax.func_177952_p());
            StructureBoundingBox box = StructureBoundingBox.func_175899_a((int)xMin, (int)yMin, (int)zMin, (int)xMax, (int)yMax, (int)zMax);
            for (TileEntity te : chunk.func_177434_r().values()) {
                ResourceLocation name;
                BlockPos pos = te.func_174877_v();
                if (!filters.contains(te.getClass()) || !box.func_175898_b((Vec3i)pos) || (name = (ResourceLocation)registry.func_177774_c(te.getClass())) == null) continue;
                this.data.add(LocationData.of(name.toString(), dim, new Vec3d((Vec3i)pos)));
                ++count;
            }
        }
        long timeAfter = System.currentTimeMillis();
        TellMe.logger.info(String.format(Locale.US, "Located %d TileEntities in %d chunks in %.3f seconds.", count, chunks.size(), Float.valueOf((float)(timeAfter - timeBefore) / 1000.0f)));
    }

    public List<String> getLines() {
        String fmtPos;
        DataDump dump = new DataDump(this.printDimension ? 5 : 4, this.format);
        String fmtChunk = this.outputType == OutputType.DUMP_CSV ? "%d,%d" : "%4d,%4d";
        String string = fmtPos = this.outputType == OutputType.DUMP_CSV ? "x = %.2f, y = %.2f, z = %.2f" : "x = %8.2f, y = %5.2f, z = %8.2f";
        if (this.printDimension) {
            for (int i = 0; i < this.data.size(); ++i) {
                LocationData entry = this.data.get(i);
                Vec3d pos = entry.pos;
                dump.addData(entry.name, String.valueOf(entry.dim), String.format("r.%d.%d", (int)pos.field_72450_a >> 9, (int)pos.field_72449_c >> 9), String.format(fmtChunk, (int)pos.field_72450_a >> 4, (int)pos.field_72449_c >> 4), String.format(fmtPos, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
            }
            dump.addTitle("ID", "Dim", "Region", "Chunk", "Location");
        } else {
            for (int i = 0; i < this.data.size(); ++i) {
                LocationData entry = this.data.get(i);
                Vec3d pos = entry.pos;
                dump.addData(entry.name, String.format("r.%d.%d", (int)pos.field_72450_a >> 9, (int)pos.field_72449_c >> 9), String.format(fmtChunk, (int)pos.field_72450_a >> 4, (int)pos.field_72449_c >> 4), String.format(fmtPos, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
            }
            dump.addTitle("ID", "Region", "Chunk", "Location");
        }
        dump.setUseColumnSeparator(true);
        return dump.getLines();
    }

    public static enum OutputType {
        INVALID,
        DUMP,
        DUMP_CSV,
        PRINT;


        public static OutputType fromArg(String arg) {
            switch (arg) {
                case "dump": {
                    return DUMP;
                }
                case "dump-csv": {
                    return DUMP_CSV;
                }
                case "print": {
                    return PRINT;
                }
            }
            return INVALID;
        }
    }

    public static enum LocateType {
        INVALID,
        BLOCK,
        ENTITY,
        TILE_ENTITY;


        public static LocateType fromArg(String arg) {
            switch (arg) {
                case "block": {
                    return BLOCK;
                }
                case "entity": {
                    return ENTITY;
                }
                case "te": {
                    return TILE_ENTITY;
                }
            }
            return INVALID;
        }
    }

    private static class LocationData {
        private final String name;
        private final int dim;
        private final Vec3d pos;

        private LocationData(String name, int dim, Vec3d pos) {
            this.name = name;
            this.dim = dim;
            this.pos = pos;
        }

        private static LocationData of(String name, int dim, Vec3d pos) {
            return new LocationData(name, dim, pos);
        }
    }
}

