/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import fi.dy.masa.tellme.datadump.EntityCountDump;
import fi.dy.masa.tellme.util.chunkprocessor.ChunkProcessorLoadedChunks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileEntitiesPerChunkCounter
extends ChunkProcessorLoadedChunks {
    private Map<ChunkPos, Integer> perChunkTotalCount = new HashMap<ChunkPos, Integer>();
    private Map<ChunkPos, Integer> perChunkTickingCount = new HashMap<ChunkPos, Integer>();
    private int totalCount;
    private int tickingCount;

    @Override
    public void processChunk(Chunk chunk) {
        Map map = chunk.func_177434_r();
        ChunkPos pos = chunk.func_76632_l();
        int count = chunk.func_177434_r().size();
        if (count == 0) {
            ++this.chunksWithZeroCount;
        } else {
            int tickingCount = 0;
            for (TileEntity te : map.values()) {
                if (!(te instanceof ITickable)) continue;
                ++tickingCount;
            }
            this.perChunkTotalCount.put(pos, count);
            this.perChunkTickingCount.put(pos, tickingCount);
            this.totalCount += count;
            this.tickingCount += tickingCount;
        }
    }

    @Override
    public EntityCountDump createDump(World world) {
        ArrayList<ChunkProcessorLoadedChunks.TileEntityCountsPerChunkHolder> counts = new ArrayList<ChunkProcessorLoadedChunks.TileEntityCountsPerChunkHolder>();
        for (ChunkPos pos : this.perChunkTotalCount.keySet()) {
            counts.add(new ChunkProcessorLoadedChunks.TileEntityCountsPerChunkHolder(pos, this.perChunkTotalCount.get(pos), this.perChunkTickingCount.get(pos)));
        }
        Collections.sort(counts);
        EntityCountDump dump = new EntityCountDump(4);
        dump.addTitle("Chunk", "Total Count", "Ticking", "Region");
        dump.addHeader("Loaded TileEntities by chunk:");
        for (ChunkProcessorLoadedChunks.TileEntityCountsPerChunkHolder holder : counts) {
            dump.addData(String.format("[%5d, %5d]", holder.pos.field_77276_a, holder.pos.field_77275_b), String.valueOf(holder.count), String.valueOf(holder.tickingCount), String.format("r.%d.%d", holder.pos.field_77276_a >> 5, holder.pos.field_77275_b >> 5));
        }
        dump.addFooter(String.format("In total there were %d loaded TileEntities", this.totalCount));
        dump.addFooter(String.format("in %d chunks, of which %d are ticking.", this.getLoadedChunkCount() - this.chunksWithZeroCount, this.tickingCount));
        return dump;
    }
}

