/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.client.GuiTinkerTank;
import slimeknights.tconstruct.smeltery.inventory.ContainerTinkerTank;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockTinkerTank;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.TileMultiblock;

public class TileTinkerTank
extends TileMultiblock<MultiblockTinkerTank>
implements ITickable,
IInventoryGui,
ISmelteryTankHandler {
    protected static final int CAPACITY_PER_BLOCK = 4000;
    protected MultiblockTinkerTank multiblock;
    protected boolean active;
    protected SmelteryTank liquids;
    protected int tick;

    public TileTinkerTank() {
        super("gui.tinkertank.name", 0);
        this.setMultiblock(new MultiblockTinkerTank(this));
        this.liquids = new SmelteryTank(this);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.isActive()) {
            if (this.tick == 0) {
                this.checkMultiblockStructure();
            }
            this.tick = (this.tick + 1) % 20;
        }
    }

    @Override
    protected void updateStructureInfo(MultiblockDetection.MultiblockStructure structure) {
        int liquidSize = (structure.xd + 2) * (structure.yd + 2) * (structure.zd + 2);
        this.liquids.setCapacity(liquidSize * 4000);
        this.markDirtyFast();
    }

    @Override
    @Nullable
    public SmelteryTank getTank() {
        return this.isActive() ? this.liquids : null;
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerTinkerTank(this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiTinkerTank(this.createContainer(inventoryplayer, world, pos), this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.minPos == null || this.maxPos == null) {
            return super.getRenderBoundingBox();
        }
        return new AxisAlignedBB((double)(this.minPos.func_177958_n() - 1), (double)Math.min(this.minPos.func_177956_o(), this.field_174879_c.func_177956_o()), (double)(this.minPos.func_177952_p() - 1), (double)(this.maxPos.func_177958_n() + 2), (double)(Math.max(this.maxPos.func_177956_o(), this.field_174879_c.func_177956_o()) + 1), (double)(this.maxPos.func_177952_p() + 2));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.liquids.setFluids(fluids);
    }

    @Override
    public void onTankChanged(List<FluidStack> fluids, FluidStack changed) {
        if (this.isServerWorld()) {
            TinkerNetwork.sendToAll((AbstractPacket)new SmelteryFluidUpdatePacket(this.field_174879_c, fluids));
        }
        this.markDirtyFast();
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.liquids.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.liquids.readFromNBT(compound);
    }
}

