/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.BlockContainerConfig;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.client.render.tileentity.RenderTileEntityEnergyBattery;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainerAutoSupply;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public class BlockEnergyBatteryConfig
extends BlockContainerConfig {
    public static BlockEnergyBatteryConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The default capacity of an energy battery.", minimalValue=0)
    public static int capacity;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The 1/X fraction of the battery capacity that is allowed to be transfered per tick.", isCommandable=true, minimalValue=0)
    public static int energyRateCapacityFraction;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The minimum energy transfer rate per tick.", isCommandable=true, minimalValue=0)
    public static int minEnergyRate;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The maximum capacity possible by combining batteries. (Make sure that you do not cross the max int size.)")
    public static int maxCapacity;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The maximum capacity visible in the creative tabs. (Make sure that you do not cross the max int size.)")
    public static int maxCreativeCapacity;

    public BlockEnergyBatteryConfig() {
        super((ModBase)IntegratedDynamics._instance, true, "energy_battery", null, BlockEnergyBattery.class);
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockEnergyContainerAutoSupply.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        this.getMod().getProxy().registerRenderer(TileEnergyBattery.class, (TileEntitySpecialRenderer)new RenderTileEntityEnergyBattery());
    }

    @SideOnly(value=Side.CLIENT)
    public void onInit(IInitListener.Step step) {
        super.onInit(step);
        if (step == IInitListener.Step.INIT) {
            for (int meta = 0; meta < 2; ++meta) {
                Item item = Item.func_150898_a((Block)this.getBlockInstance());
                String modId = this.getMod().getModId();
                String itemName = this.getModelName(new ItemStack(item, 1, meta));
                ModelResourceLocation modelResourceLocation = new ModelResourceLocation(modId + ":" + itemName, "inventory");
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, modelResourceLocation);
            }
        }
    }

    static {
        capacity = 1000000;
        energyRateCapacityFraction = 2000;
        minEnergyRate = 2000;
        maxCapacity = 655360000;
        maxCreativeCapacity = 40960000;
    }
}

