/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.cable;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public abstract class CableDefault
implements ICable {
    protected abstract boolean isForceDisconnectable();

    protected abstract EnumFacingMap<Boolean> getForceDisconnected();

    protected abstract EnumFacingMap<Boolean> getConnected();

    protected abstract void markDirty();

    protected abstract void sendUpdate();

    protected abstract World getWorld();

    protected abstract BlockPos getPos();

    protected boolean isForceDisconnected(EnumFacing side) {
        if (!this.isForceDisconnectable()) {
            return false;
        }
        if (!this.getForceDisconnected().containsKey((Object)side)) {
            return false;
        }
        return (Boolean)this.getForceDisconnected().get((Object)side);
    }

    @Override
    public boolean canConnect(ICable connector, EnumFacing side) {
        return !this.isForceDisconnected(side);
    }

    @Override
    public void updateConnections() {
        World world = this.getWorld();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            boolean cableConnected = CableHelpers.canCableConnectTo((IBlockAccess)world, this.getPos(), side, this);
            this.getConnected().put((Enum)side, (Object)cableConnected);
            if (cableConnected || !this.isForceDisconnectable() || !this.canConnect(this, side)) continue;
            this.getForceDisconnected().put((Enum)side, (Object)false);
        }
        this.markDirty();
        this.sendUpdate();
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        if (this.getPos() == null) {
            return false;
        }
        if (this.getConnected().isEmpty()) {
            this.updateConnections();
        }
        return this.getConnected().containsKey((Object)side) && (Boolean)this.getConnected().get((Object)side) != false;
    }

    @Override
    public void disconnect(EnumFacing side) {
        if (this.isForceDisconnectable()) {
            this.getForceDisconnected().put((Enum)side, (Object)true);
        }
    }

    @Override
    public void reconnect(EnumFacing side) {
        if (this.isForceDisconnectable()) {
            this.getForceDisconnected().remove((Object)side);
        }
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack((Block)BlockCable.getInstance());
    }
}

