/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import com.google.common.base.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.model.CableModelBase;
import org.cyclops.integrateddynamics.client.model.IRenderState;

public class CableModel
extends CableModelBase {
    public CableModel(IExtendedBlockState state, EnumFacing facing, long rand) {
        super((IBlockState)state, facing, rand);
    }

    public CableModel(ItemStack itemStack, World world, EntityLivingBase entity) {
        super(itemStack, world, entity);
    }

    public CableModel() {
    }

    @Override
    protected boolean isRealCable() {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.REALCABLE, (Object)true);
    }

    @Override
    protected Optional<IBlockState> getFacade() {
        return (Optional)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.FACADE, (Object)Optional.absent());
    }

    @Override
    protected boolean isConnected(EnumFacing side) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.CONNECTED[side.ordinal()], (Object)false);
    }

    @Override
    protected boolean hasPart(EnumFacing side) {
        return this.getPartRenderPosition(side) != PartRenderPosition.NONE;
    }

    @Override
    protected PartRenderPosition getPartRenderPosition(EnumFacing side) {
        return (PartRenderPosition)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)PartRenderPosition.NONE);
    }

    @Override
    protected boolean shouldRenderParts() {
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT && BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.PARTCONTAINER, null) != null;
    }

    @Override
    protected IBakedModel getPartModel(EnumFacing side) {
        IPartContainer partContainer = (IPartContainer)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.PARTCONTAINER, null);
        IBlockState blockState = partContainer != null && partContainer.hasPart(side) ? partContainer.getPart(side).getBlockState(partContainer, side) : null;
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        return blockModelShapes.func_178125_b(blockState);
    }

    @Override
    protected IRenderState getRenderState() {
        return (IRenderState)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.RENDERSTATE, null);
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        return new CableModel((IExtendedBlockState)state, side, rand);
    }

    public IBakedModel handleItemState(ItemStack stack, World world, EntityLivingBase entity) {
        return new CableModel(stack, world, entity);
    }
}

