/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part.aspect.read;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.block.BlockCapabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.capability.network.EnergyNetworkConfig;
import org.cyclops.integrateddynamics.core.NoteBlockEventReceiver;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeCategoryAny;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositionedInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositionedTankCapacities;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositionedTankFluidStacks;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;

public class AspectReadBuilders {
    public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Pair<PartTarget, IAspectProperties>> BUILDER_BOOLEAN = AspectBuilder.forReadType(ValueTypes.BOOLEAN);
    public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Pair<PartTarget, IAspectProperties>> BUILDER_INTEGER = AspectBuilder.forReadType(ValueTypes.INTEGER);
    public static final AspectBuilder<ValueTypeDouble.ValueDouble, ValueTypeDouble, Pair<PartTarget, IAspectProperties>> BUILDER_DOUBLE = AspectBuilder.forReadType(ValueTypes.DOUBLE);
    public static final AspectBuilder<ValueTypeLong.ValueLong, ValueTypeLong, Pair<PartTarget, IAspectProperties>> BUILDER_LONG = AspectBuilder.forReadType(ValueTypes.LONG);
    public static final AspectBuilder<ValueTypeString.ValueString, ValueTypeString, Pair<PartTarget, IAspectProperties>> BUILDER_STRING = AspectBuilder.forReadType(ValueTypes.STRING);
    public static final AspectBuilder<ValueObjectTypeEntity.ValueEntity, ValueObjectTypeEntity, Pair<PartTarget, IAspectProperties>> BUILDER_ENTITY = AspectBuilder.forReadType(ValueTypes.OBJECT_ENTITY);
    public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Pair<PartTarget, IAspectProperties>> BUILDER_LIST = AspectBuilder.forReadType(ValueTypes.LIST);
    public static final AspectBuilder<ValueTypeNbt.ValueNbt, ValueTypeNbt, Pair<PartTarget, IAspectProperties>> BUILDER_NBT = AspectBuilder.forReadType(ValueTypes.NBT);
    public static final AspectBuilder<IValue, ValueTypeCategoryAny, Pair<PartTarget, IAspectProperties>> BUILDER_ANY = AspectBuilder.forReadType(ValueTypes.CATEGORY_ANY);
    public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Pair<PartTarget, IAspectProperties>> BUILDER_OPERATOR = AspectBuilder.forReadType(ValueTypes.OPERATOR);
    public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Pair<PartTarget, IAspectProperties>> BUILDER_OBJECT_ITEMSTACK = AspectBuilder.forReadType(ValueTypes.OBJECT_ITEMSTACK);
    public static final AspectBuilder<ValueObjectTypeBlock.ValueBlock, ValueObjectTypeBlock, Pair<PartTarget, IAspectProperties>> BUILDER_OBJECT_BLOCK = AspectBuilder.forReadType(ValueTypes.OBJECT_BLOCK);
    public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Pair<PartTarget, IAspectProperties>> BUILDER_OBJECT_FLUIDSTACK = AspectBuilder.forReadType(ValueTypes.OBJECT_FLUIDSTACK);
    public static final IAspectValuePropagator<Boolean, ValueTypeBoolean.ValueBoolean> PROP_GET_BOOLEAN = ValueTypeBoolean.ValueBoolean::of;
    public static final IAspectValuePropagator<Integer, ValueTypeInteger.ValueInteger> PROP_GET_INTEGER = ValueTypeInteger.ValueInteger::of;
    public static final IAspectValuePropagator<Double, ValueTypeDouble.ValueDouble> PROP_GET_DOUBLE = ValueTypeDouble.ValueDouble::of;
    public static final IAspectValuePropagator<Long, ValueTypeLong.ValueLong> PROP_GET_LONG = ValueTypeLong.ValueLong::of;
    public static final IAspectValuePropagator<ItemStack, ValueObjectTypeItemStack.ValueItemStack> PROP_GET_ITEMSTACK = ValueObjectTypeItemStack.ValueItemStack::of;
    public static final IAspectValuePropagator<String, ValueTypeString.ValueString> PROP_GET_STRING = ValueTypeString.ValueString::of;
    public static final IAspectValuePropagator<IBlockState, ValueObjectTypeBlock.ValueBlock> PROP_GET_BLOCK = ValueObjectTypeBlock.ValueBlock::of;
    public static final IAspectValuePropagator<FluidStack, ValueObjectTypeFluidStack.ValueFluidStack> PROP_GET_FLUIDSTACK = ValueObjectTypeFluidStack.ValueFluidStack::of;
    public static final IAspectValuePropagator<NBTTagCompound, ValueTypeNbt.ValueNbt> PROP_GET_NBT = ValueTypeNbt.ValueNbt::of;
    public static final Predicate<ValueTypeInteger.ValueInteger> VALIDATOR_INTEGER_POSITIVE = input -> input.getRawValue() >= 0;
    public static final Predicate<ValueTypeDouble.ValueDouble> VALIDATOR_DOUBLE_POSITIVE = input -> input.getRawValue() >= 0.0;
    public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_LISTINDEX = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.listindex.name", VALIDATOR_INTEGER_POSITIVE);
    public static final IAspectProperties LIST_PROPERTIES = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROPERTY_LISTINDEX));

    static {
        LIST_PROPERTIES.setValue(PROPERTY_LISTINDEX, ValueTypeInteger.ValueInteger.of(0));
    }

    public static final class World {
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, DimPos> PROP_GET = input -> ((PartTarget)input.getLeft()).getTarget().getPos();
        public static final IAspectValuePropagator<DimPos, net.minecraft.world.World> PROP_GET_WORLD = DimPos::getWorld;
        public static final IAspectValuePropagator<DimPos, BlockPos> PROP_GET_POS = DimPos::getBlockPos;
        private static final com.google.common.base.Predicate<net.minecraft.entity.Entity> ENTITY_SELECTOR_ITEMFRAME = entity -> entity instanceof EntityItemFrame;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, EntityItemFrame> PROP_GET_ITEMFRAME = pair -> {
            DimPos dimPos = ((PartTarget)pair.getLeft()).getTarget().getPos();
            EnumFacing facing = ((PartTarget)pair.getLeft()).getTarget().getSide();
            List entities = dimPos.getWorld().func_175674_a(null, new AxisAlignedBB(dimPos.getBlockPos(), dimPos.getBlockPos().func_177982_a(1, 1, 1)), ENTITY_SELECTOR_ITEMFRAME);
            for (net.minecraft.entity.Entity entity : entities) {
                if (EnumFacing.func_176733_a((double)((EntityItemFrame)entity).field_70177_z) != facing.func_176734_d()) continue;
                return (EntityItemFrame)entity;
            }
            return null;
        };
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, DimPos> BUILDER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET, "world");
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, DimPos> BUILDER_INTEGER = BUILDER_INTEGER.handle(PROP_GET, "world");
        public static final AspectBuilder<ValueTypeDouble.ValueDouble, ValueTypeDouble, DimPos> BUILDER_DOUBLE = BUILDER_DOUBLE.handle(PROP_GET, "world");
        public static final AspectBuilder<ValueTypeLong.ValueLong, ValueTypeLong, DimPos> BUILDER_LONG = BUILDER_LONG.handle(PROP_GET, "world");
        public static final AspectBuilder<ValueTypeString.ValueString, ValueTypeString, DimPos> BUILDER_STRING = BUILDER_STRING.handle(PROP_GET, "world");
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, DimPos> BUILDER_LIST = BUILDER_LIST.handle(PROP_GET, "world");
    }

    public static final class Redstone {
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_INTERVAL = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.interval.name", VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_LENGTH = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.length.name", VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_OFFSET = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.offset.name", VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectProperties PROPERTIES_CLOCK = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROPERTY_INTERVAL, PROPERTY_LENGTH, PROPERTY_OFFSET));
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, Integer> PROP_GET;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, Integer> PROP_GET_COMPARATOR;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, Boolean> PROP_GET_CLOCK;
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Integer> BUILDER_BOOLEAN;
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Boolean> BUILDER_BOOLEAN_CLOCK;
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Integer> BUILDER_INTEGER;
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Integer> BUILDER_INTEGER_COMPARATOR;

        static {
            PROPERTIES_CLOCK.setValue(PROPERTY_INTERVAL, ValueTypeInteger.ValueInteger.of(20));
            PROPERTIES_CLOCK.setValue(PROPERTY_LENGTH, ValueTypeInteger.ValueInteger.of(1));
            PROPERTIES_CLOCK.setValue(PROPERTY_OFFSET, ValueTypeInteger.ValueInteger.of(0));
            PROP_GET = input -> {
                DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
                int power = dimPos.getWorld().func_175651_c(dimPos.getBlockPos(), ((PartTarget)input.getLeft()).getCenter().getSide());
                if (power == 0) {
                    IBlockState targetBlockState = dimPos.getWorld().func_180495_p(dimPos.getBlockPos());
                    power = targetBlockState.func_177230_c() == Blocks.field_150488_af ? (Integer)targetBlockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0;
                }
                return power;
            };
            PROP_GET_COMPARATOR = input -> {
                DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
                IBlockState blockState = dimPos.getWorld().func_180495_p(dimPos.getBlockPos());
                return blockState.func_185912_n() ? blockState.func_185888_a(dimPos.getWorld(), dimPos.getBlockPos()) : 0;
            };
            PROP_GET_CLOCK = input -> {
                int interval = Math.max(1, ((IAspectProperties)input.getRight()).getValue(PROPERTY_INTERVAL).getRawValue());
                int length = Math.max(1, ((IAspectProperties)input.getRight()).getValue(PROPERTY_LENGTH).getRawValue());
                int offset = ((IAspectProperties)input.getRight()).getValue(PROPERTY_OFFSET).getRawValue();
                return (((PartTarget)input.getLeft()).getTarget().getPos().getWorld().func_82737_E() - (long)offset) % (long)interval < (long)length;
            };
            BUILDER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET, "redstone");
            BUILDER_BOOLEAN_CLOCK = BUILDER_BOOLEAN.handle(PROP_GET_CLOCK, "redstone").withProperties(PROPERTIES_CLOCK);
            BUILDER_INTEGER = BUILDER_INTEGER.handle(PROP_GET, "redstone");
            BUILDER_INTEGER_COMPARATOR = BUILDER_INTEGER.handle(PROP_GET_COMPARATOR, "redstone");
        }
    }

    public static final class Network {
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_CHANNEL = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.channel.name");
        public static final IAspectProperties PROPERTIES = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROPERTY_CHANNEL));
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, INetwork> PROP_GET_NETWORK;
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, INetwork> BUILDER_BOOLEAN;
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, INetwork> BUILDER_INTEGER;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IEnergyStorage> PROP_GET_ENERGY_CHANNEL;
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, IEnergyStorage> ENERGY_BUILDER;

        static {
            PROPERTIES.setValue(PROPERTY_CHANNEL, ValueTypeInteger.ValueInteger.of(-1));
            PROP_GET_NETWORK = input -> {
                DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
                return NetworkHelpers.getNetwork((IBlockAccess)dimPos.getWorld(), dimPos.getBlockPos(), ((PartTarget)input.getLeft()).getTarget().getSide());
            };
            BUILDER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET_NETWORK, "network");
            BUILDER_INTEGER = BUILDER_INTEGER.handle(PROP_GET_NETWORK, "network");
            PROP_GET_ENERGY_CHANNEL = input -> {
                DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)dimPos.getWorld(), dimPos.getBlockPos(), ((PartTarget)input.getLeft()).getTarget().getSide());
                int channel = ((IAspectProperties)input.getRight()).getValue(PROPERTY_CHANNEL).getRawValue();
                return network != null && network.hasCapability(EnergyNetworkConfig.CAPABILITY) ? (IEnergyStorage)network.getCapability(EnergyNetworkConfig.CAPABILITY).getChannelExternal(CapabilityEnergy.ENERGY, channel) : null;
            };
            ENERGY_BUILDER = BUILDER_INTEGER.handle(PROP_GET_ENERGY_CHANNEL, "network").withProperties(PROPERTIES);
        }
    }

    public static final class Machine {
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IWorker> PROP_GET_WORKER = input -> {
            DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
            return (IWorker)TileHelpers.getCapability((net.minecraft.world.World)dimPos.getWorld(), (BlockPos)dimPos.getBlockPos(), (EnumFacing)((PartTarget)input.getLeft()).getTarget().getSide(), Capabilities.WORKER);
        };
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, ITemperature> PROP_GET_TEMPERATURE = input -> {
            DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
            return (ITemperature)TileHelpers.getCapability((net.minecraft.world.World)dimPos.getWorld(), (BlockPos)dimPos.getBlockPos(), (EnumFacing)((PartTarget)input.getLeft()).getTarget().getSide(), Capabilities.TEMPERATURE);
        };
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IRecipeHandler> PROP_GET_RECIPE_HANDLER = new IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IRecipeHandler>(){

            @Override
            public IRecipeHandler getOutput(Pair<PartTarget, IAspectProperties> input) {
                DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
                IRecipeHandler recipeHandler = (IRecipeHandler)TileHelpers.getCapability((net.minecraft.world.World)dimPos.getWorld(), (BlockPos)dimPos.getBlockPos(), (EnumFacing)((PartTarget)input.getLeft()).getTarget().getSide(), Capabilities.RECIPE_HANDLER);
                if (recipeHandler == null) {
                    IBlockState blockState = dimPos.getWorld().func_180495_p(dimPos.getBlockPos());
                    return (IRecipeHandler)BlockCapabilities.getInstance().getCapability(blockState, Capabilities.RECIPE_HANDLER, (IBlockAccess)dimPos.getWorld(), dimPos.getBlockPos(), ((PartTarget)input.getLeft()).getTarget().getSide());
                }
                return recipeHandler;
            }
        };
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, IWorker> BUILDER_WORKER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET_WORKER, "machine");
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, ITemperature> BUILDER_TEMPERATURE_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET_TEMPERATURE, "temperature");
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, IRecipeHandler> BUILDER_RECIPE_HANDLER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET_RECIPE_HANDLER, "recipehandler");
        public static final AspectBuilder<ValueTypeDouble.ValueDouble, ValueTypeDouble, ITemperature> BUILDER_TEMPERATURE_DOUBLE = BUILDER_DOUBLE.handle(PROP_GET_TEMPERATURE, "temperature");
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Pair<PartTarget, IAspectProperties>> BUILDER_RECIPE_HANDLER_LIST = BUILDER_LIST.appendKind("recipehandler");
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Pair<PartTarget, IAspectProperties>> BUILDER_RECIPE_HANDLER_OPERATOR = BUILDER_OPERATOR.appendKind("recipehandler");
    }

    public static final class Inventory {
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_SLOTID = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.slotid.name", VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectProperties PROPERTIES = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROPERTY_SLOTID));
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IItemHandler> PROP_GET;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, ItemStack> PROP_GET_SLOT;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, ValueTypeList.ValueList> PROP_GET_LIST;
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, IItemHandler> BUILDER_BOOLEAN;
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, IItemHandler> BUILDER_INTEGER;
        public static final AspectBuilder<ValueTypeDouble.ValueDouble, ValueTypeDouble, IItemHandler> BUILDER_DOUBLE;
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, ItemStack> BUILDER_ITEMSTACK;

        static {
            PROPERTIES.setValue(PROPERTY_SLOTID, ValueTypeInteger.ValueInteger.of(0));
            PROP_GET = input -> {
                PartPos target = ((PartTarget)input.getLeft()).getTarget();
                return (IItemHandler)TileHelpers.getCapability((net.minecraft.world.World)target.getPos().getWorld(), (BlockPos)target.getPos().getBlockPos(), (EnumFacing)target.getSide(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            };
            PROP_GET_SLOT = input -> {
                PartPos target = ((PartTarget)input.getLeft()).getTarget();
                IItemHandler itemHandler = (IItemHandler)TileHelpers.getCapability((net.minecraft.world.World)target.getPos().getWorld(), (BlockPos)target.getPos().getBlockPos(), (EnumFacing)target.getSide(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                int slotId = ((IAspectProperties)input.getRight()).getValue(PROPERTY_SLOTID).getRawValue();
                if (itemHandler != null && slotId >= 0 && slotId < itemHandler.getSlots()) {
                    return itemHandler.getStackInSlot(slotId);
                }
                return ItemStack.field_190927_a;
            };
            PROP_GET_LIST = input -> ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyPositionedInventory(((PartTarget)input.getLeft()).getTarget().getPos(), ((PartTarget)input.getLeft()).getTarget().getSide()));
            BUILDER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET, "inventory");
            BUILDER_INTEGER = BUILDER_INTEGER.handle(PROP_GET, "inventory");
            BUILDER_DOUBLE = BUILDER_DOUBLE.handle(PROP_GET, "inventory");
            BUILDER_ITEMSTACK = BUILDER_OBJECT_ITEMSTACK.handle(PROP_GET_SLOT, "inventory").withProperties(PROPERTIES);
        }
    }

    public static final class Fluid {
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_TANKID = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.tankid.name", VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectProperties PROPERTIES = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROP_TANKID));
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IFluidTankProperties[]> PROP_GET;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IFluidTankProperties> PROP_GET_ACTIVATABLE;
        public static final IAspectValuePropagator<IFluidTankProperties, FluidStack> PROP_GET_FLUIDSTACK;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, ValueTypeList.ValueList> PROP_GET_LIST_FLUIDSTACKS;
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, ValueTypeList.ValueList> PROP_GET_LIST_CAPACITIES;
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, IFluidTankProperties[]> BUILDER_BOOLEAN;
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, IFluidTankProperties[]> BUILDER_INTEGER;
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, IFluidTankProperties> BUILDER_INTEGER_ACTIVATABLE;
        public static final AspectBuilder<ValueTypeDouble.ValueDouble, ValueTypeDouble, IFluidTankProperties> BUILDER_DOUBLE_ACTIVATABLE;

        static {
            PROPERTIES.setValue(PROP_TANKID, ValueTypeInteger.ValueInteger.of(0));
            PROP_GET = input -> {
                DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
                IFluidHandler fluidHandler = (IFluidHandler)TileHelpers.getCapability((DimPos)dimPos, (EnumFacing)((PartTarget)input.getLeft()).getTarget().getSide(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                if (fluidHandler != null) {
                    return fluidHandler.getTankProperties();
                }
                return new IFluidTankProperties[0];
            };
            PROP_GET_ACTIVATABLE = input -> {
                DimPos dimPos = ((PartTarget)input.getLeft()).getTarget().getPos();
                IFluidHandler fluidHandler = (IFluidHandler)TileHelpers.getCapability((DimPos)dimPos, (EnumFacing)((PartTarget)input.getLeft()).getTarget().getSide(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                if (fluidHandler != null) {
                    IFluidTankProperties[] tankInfo = fluidHandler.getTankProperties();
                    int i = ((IAspectProperties)input.getRight()).getValue(PROP_TANKID).getRawValue();
                    if (tankInfo != null && i < tankInfo.length) {
                        return tankInfo[i];
                    }
                }
                return null;
            };
            PROP_GET_FLUIDSTACK = tankInfo -> tankInfo != null ? tankInfo.getContents() : null;
            PROP_GET_LIST_FLUIDSTACKS = input -> ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyPositionedTankFluidStacks(((PartTarget)input.getLeft()).getTarget().getPos(), ((PartTarget)input.getLeft()).getTarget().getSide()));
            PROP_GET_LIST_CAPACITIES = input -> ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyPositionedTankCapacities(((PartTarget)input.getLeft()).getTarget().getPos(), ((PartTarget)input.getLeft()).getTarget().getSide()));
            BUILDER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET, "fluid");
            BUILDER_INTEGER = BUILDER_INTEGER.handle(PROP_GET, "fluid");
            BUILDER_INTEGER_ACTIVATABLE = BUILDER_INTEGER.handle(PROP_GET_ACTIVATABLE, "fluid").withProperties(PROPERTIES);
            BUILDER_DOUBLE_ACTIVATABLE = BUILDER_DOUBLE.handle(PROP_GET_ACTIVATABLE, "fluid").withProperties(PROPERTIES);
        }
    }

    public static final class ExtraDimensional {
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, MinecraftServer> PROP_GET = input -> FMLCommonHandler.instance().getMinecraftServerInstance();
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, MinecraftServer> BUILDER_INTEGER = BUILDER_INTEGER.handle(PROP_GET, "extradimensional");
        public static final AspectBuilder<ValueTypeDouble.ValueDouble, ValueTypeDouble, MinecraftServer> BUILDER_DOUBLE = BUILDER_DOUBLE.handle(PROP_GET, "extradimensional");
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, MinecraftServer> BUILDER_LIST = BUILDER_LIST.handle(PROP_GET, "extradimensional");
    }

    public static final class Entity {
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, DimPos> PROP_GET = input -> ((PartTarget)input.getLeft()).getTarget().getPos();
        public static final AspectBuilder<ValueObjectTypeEntity.ValueEntity, ValueObjectTypeEntity, Pair<PartTarget, IAspectProperties>> BUILDER_ENTITY = BUILDER_ENTITY.appendKind("entity");
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, DimPos> BUILDER_LIST = BUILDER_LIST.handle(PROP_GET, "entity");
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Pair<PartTarget, IAspectProperties>> BUILDER_ITEMSTACK = BUILDER_OBJECT_ITEMSTACK.appendKind("entity");
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Pair<PartTarget, IAspectProperties>> BUILDER_INTEGER_ALL = BUILDER_INTEGER.appendKind("entity");
    }

    public static final class Block {
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, DimPos> PROP_GET = input -> ((PartTarget)input.getLeft()).getTarget().getPos();
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, DimPos> BUILDER_BOOLEAN = BUILDER_BOOLEAN.handle(PROP_GET, "block");
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, DimPos> BUILDER_INTEGER = BUILDER_INTEGER.handle(PROP_GET, "block");
        public static final AspectBuilder<ValueTypeString.ValueString, ValueTypeString, DimPos> BUILDER_STRING = BUILDER_STRING.handle(PROP_GET, "block");
        public static final AspectBuilder<ValueObjectTypeBlock.ValueBlock, ValueObjectTypeBlock, DimPos> BUILDER_BLOCK = BUILDER_OBJECT_BLOCK.handle(PROP_GET, "block");
        public static final AspectBuilder<ValueTypeNbt.ValueNbt, ValueTypeNbt, DimPos> BUILDER_NBT = BUILDER_NBT.handle(PROP_GET, "block");
    }

    public static final class Audio {
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_RANGE = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.range.name", VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectProperties NOTE_PROPERTIES = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROPERTY_RANGE));
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Pair<PartTarget, IAspectProperties>> BUILDER_INTEGER;

        public static AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Integer> forInstrument(NoteBlockEvent.Instrument instrument) {
            return BUILDER_INTEGER.appendKind("instrument").handle(input -> {
                for (NoteBlockEvent.Play event : NoteBlockEventReceiver.getInstance().getEvents().get((Object)instrument)) {
                    net.minecraft.world.World world = ((PartTarget)input.getLeft()).getTarget().getPos().getWorld();
                    BlockPos pos = ((PartTarget)input.getLeft()).getTarget().getPos().getBlockPos();
                    int range = ((IAspectProperties)input.getRight()).getValue(PROPERTY_RANGE).getRawValue();
                    if (world.field_73011_w.getDimension() != event.getWorld().field_73011_w.getDimension() || !(pos.func_177951_i((Vec3i)event.getPos()) <= (double)(range * range))) continue;
                    return event.getVanillaNoteId();
                }
                return -1;
            }, instrument.name().toLowerCase(Locale.ENGLISH)).withProperties(NOTE_PROPERTIES);
        }

        static {
            NOTE_PROPERTIES.setValue(PROPERTY_RANGE, ValueTypeInteger.ValueInteger.of(64));
            BUILDER_INTEGER = BUILDER_INTEGER.appendKind("audio");
        }
    }
}

