/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity;

import baguchan.hunterillager.HunterSounds;
import baguchan.hunterillager.entity.ai.EntityAICollectItem;
import baguchan.hunterillager.entity.ai.EntityAIHunterMoveTowardsRestriction;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHunterIllager
extends AbstractIllager
implements IRangedAttackMob {
    private final InventoryBasic illagerInventory;
    private BlockPos homePosition = BlockPos.field_177992_a;
    private float maximumHomeDistance = -1.0f;
    protected int eattick = 0;
    private int cooldownTicks;

    public EntityHunterIllager(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
        this.illagerInventory = new InventoryBasic("Items", false, 8);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70728_aV = 4;
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRangedBow((EntityMob)this, 0.95, 20, 16.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICollectItem(this, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIHunterMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.9));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{AbstractIllager.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 10, true, false, (Predicate)new Predicate<EntityAnimal>(){

            public boolean apply(@Nullable EntityAnimal p_apply_1_) {
                return !(p_apply_1_ instanceof EntityTameable) && !(p_apply_1_ instanceof EntityHorse) && !(p_apply_1_ instanceof EntityLlama) && EntityHunterIllager.this.getCooldownTicks() <= 0;
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(22.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(28.0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        this.illagerInventory.func_174894_a(new ItemStack(Items.field_151157_am, 3 + this.field_70146_Z.nextInt(3)));
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.illagerInventory.func_174894_a(new ItemStack(Items.field_151153_ao, 1));
        }
        return livingdata;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("CooldownTicks", this.cooldownTicks);
        compound.func_74768_a("HomePosX", this.homePosition.func_177958_n());
        compound.func_74768_a("HomePosY", this.homePosition.func_177956_o());
        compound.func_74768_a("HomePosZ", this.homePosition.func_177952_p());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.illagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.illagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.cooldownTicks = compound.func_74762_e("CooldownTicks");
        this.homePosition = new BlockPos(compound.func_74762_e("HomePosX"), compound.func_74762_e("HomePosY"), compound.func_74762_e("HomePosZ"));
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ItemStack itemstack = new ItemStack(nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.illagerInventory.func_174894_a(itemstack);
        }
        this.func_98053_h(true);
    }

    public boolean func_180485_d(BlockPos pos) {
        if (this.maximumHomeDistance == -1.0f) {
            return true;
        }
        return this.homePosition.func_177951_i((Vec3i)pos) < (double)(this.maximumHomeDistance * this.maximumHomeDistance);
    }

    public void func_175449_a(BlockPos pos, int distance) {
        this.homePosition = pos;
        this.maximumHomeDistance = distance;
    }

    public BlockPos func_180486_cf() {
        return this.homePosition;
    }

    public InventoryBasic getIllagerInventory() {
        return this.illagerInventory;
    }

    public boolean isCooldown() {
        return this.cooldownTicks > 0;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public void setCooldownTicks(int tick) {
        this.cooldownTicks = tick;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.eattick = Math.max(0, this.eattick - 1);
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
        if (this.eattick == 1) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
        }
        super.func_70636_d();
        this.func_82168_bl();
        if (this.field_70146_Z.nextFloat() < 0.0048f && this.func_110143_aJ() < this.func_110138_aP()) {
            this.eatFood();
        }
    }

    private void eatFood() {
        ItemStack itemstack = this.findFood();
        if (!itemstack.func_190926_b()) {
            ItemFood itemfood = (ItemFood)itemstack.func_77973_b();
            this.func_70691_i(itemfood.func_150905_g(itemstack));
            itemstack.func_190918_g(1);
            this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
            this.eattick = 20;
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, itemstack);
        }
    }

    private ItemStack findFood() {
        for (int i = 0; i < this.illagerInventory.func_70302_i_(); ++i) {
            ItemStack friendsstack = this.illagerInventory.func_70301_a(i);
            if (!this.canIllagerPickupItem(friendsstack.func_77973_b())) continue;
            return friendsstack;
        }
        return ItemStack.field_190927_a;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.canIllagerPickupItem(item)) {
            ItemStack itemstack1 = this.illagerInventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.illagerInventory != null) {
            for (int i = 0; i < this.illagerInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.illagerInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public boolean canIllagerPickupItem(Item itemIn) {
        return itemIn instanceof ItemFood && ((ItemFood)itemIn).func_77845_h() && itemIn != Items.field_151078_bh || itemIn == Items.field_151025_P;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191270_ho;
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (!(entity instanceof AbstractIllager)) {
            this.func_184185_a(HunterSounds.HUNTER_ILLAGER_LAUGH, this.func_70599_aP() + 0.15f, this.func_70647_i());
            this.setCooldownTicks(300);
        }
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("hunterillager", "entity/hunter_illager");
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.ILLAGER) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.createArrowEntity(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow createArrowEntity(float p_193097_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_193097_1_);
        return entitytippedarrow;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAggressive() {
        return this.func_193078_a(1);
    }

    public void func_184724_a(boolean swingingArms) {
        this.func_193079_a(1, swingingArms);
    }

    @SideOnly(value=Side.CLIENT)
    public AbstractIllager.IllagerArmPose func_193077_p() {
        return this.isAggressive() ? AbstractIllager.IllagerArmPose.BOW_AND_ARROW : AbstractIllager.IllagerArmPose.CROSSED;
    }
}

