/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.textfield;

import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import net.shadowfacts.shadowmc.ui.element.textfield.UITextField;

public class UIIntegerField
extends UITextField {
    private IntConsumer handler;
    private int min;
    private int max;

    public UIIntegerField(IntConsumer handler, int value, int min, int max, String id, String ... classes) {
        super(Integer.toString(value), Pattern.compile("-?\\d+"), null, id, classes);
        this.handler = handler;
        this.min = min;
        this.max = max;
    }

    public UIIntegerField(IntConsumer handler, int value, String id, String ... classes) {
        this(handler, value, Integer.MIN_VALUE, Integer.MAX_VALUE, id, classes);
    }

    @Override
    protected void handleChange() {
        long val;
        if (this.text.isEmpty()) {
            this.text = "0";
        }
        if ((val = Long.parseLong(this.text)) < (long)this.min) {
            this.text = Integer.toString(this.min);
        } else if (val > (long)this.max) {
            this.text = Integer.toString(this.max);
        }
        this.handler.accept(Integer.parseInt(this.text));
    }
}

