/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.explosive.blast.Blast;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityExplosion
extends Entity
implements IEntityAdditionalSpawnData {
    private Blast blast;
    private double blastYOffset = 0.0;
    private boolean endExplosion = false;

    public EntityExplosion(World world) {
        super(world);
        this.field_70156_m = true;
        this.field_70145_X = true;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70158_ak = true;
        this.field_70173_aa = 0;
    }

    public EntityExplosion(Blast blast) {
        this(blast.world());
        this.setBlast(blast);
        if (ConfigDebug.DEBUG_EXPLOSIVES) {
            ICBMClassic.logger().info("EntityExplosion#new(" + blast + ") Created new blast controller entity");
        }
    }

    public String func_70005_c_() {
        return "Explosion[" + this.blast + "]";
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_70014_b(nbt);
            ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.func_70037_a(ByteBufUtils.readTag((ByteBuf)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        if (this.getBlast() == null || this.getBlast().controller != this || !this.getBlast().isAlive) {
            this.func_70106_y();
            return;
        }
        if (this.getBlast().isMovable() && (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0)) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70159_w /= (double)speed;
            this.field_70181_x /= (double)speed;
            this.field_70179_y /= (double)speed;
            speed = Math.min(speed, 0.5f);
            this.field_70159_w *= (double)speed;
            this.field_70181_x *= (double)speed;
            this.field_70179_y *= (double)speed;
            this.func_174826_a(this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
            this.field_70165_t = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
            this.field_70163_u = (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0;
            this.field_70161_v = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
            this.getBlast().onPositionUpdate(this.field_70165_t, this.field_70163_u + this.blastYOffset, this.field_70161_v);
        }
        if (this.field_70173_aa == 1) {
            this.getBlast().preExplode();
        } else if (this.field_70173_aa % this.getBlast().proceduralInterval() == 0) {
            if (!this.endExplosion) {
                this.getBlast().onExplode();
            } else {
                this.func_70106_y();
                this.getBlast().postExplode();
            }
        }
    }

    public void func_70091_d(MoverType type, double p_70091_1_, double p_70091_3_, double p_70091_5_) {
    }

    public void endExplosion() {
        this.endExplosion = true;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        try {
            NBTTagCompound blastSave = nbt.func_74775_l("blast");
            this.blastYOffset = nbt.func_74769_h("blastPosY");
            if (this.getBlast() == null) {
                Class<?> clazz = Class.forName(blastSave.func_74779_i("class"));
                Constructor<?> constructor = clazz.getConstructor(World.class, Entity.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE);
                this.setBlast((Blast)constructor.newInstance(this.field_70170_p, null, this.field_70165_t, this.field_70163_u + this.blastYOffset, this.field_70161_v, 0));
            }
            this.getBlast().readFromNBT(blastSave);
        }
        catch (Exception e) {
            ICBMClassic.logger().error("ICBM error in loading an explosion!");
            e.printStackTrace();
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("blastPosY", this.blastYOffset);
        NBTTagCompound baoZhaNBT = new NBTTagCompound();
        baoZhaNBT.func_74778_a("class", this.getBlast().getClass().getCanonicalName());
        this.getBlast().writeToNBT(baoZhaNBT);
        nbt.func_74782_a("blast", (NBTBase)baoZhaNBT);
    }

    public Blast getBlast() {
        return this.blast;
    }

    public void setBlast(Blast blast) {
        this.blast = blast;
        if (blast != null) {
            this.blast.controller = this;
            this.func_70107_b(blast.location.x(), !blast.isMovable() ? -1.0 : blast.y(), blast.location.z());
            this.blastYOffset = blast.isMovable() ? 0.0 : blast.y() + 1.0;
        }
    }
}

