/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.client.ICBMSounds;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.blast.BlastMutation;
import icbm.classic.content.potion.CustomPotionEffect;
import icbm.classic.lib.transform.vector.Pos;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class BlastChemical
extends Blast {
    public static final int PARTICLES_TO_SPAWN = 200;
    public static final int TICKS_BETWEEN_RUNS = 5;
    private int duration;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private boolean playShortSoundFX;
    private boolean isContagious;
    private boolean isPoisonous;
    private boolean isConfuse;
    private boolean isMutate;

    public BlastChemical(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastChemical(World world, Entity entity, double x, double y, double z, float size, int duration, boolean playShortSoundFX) {
        this(world, entity, x, y, z, size);
        this.duration = duration / this.proceduralInterval();
        this.playShortSoundFX = playShortSoundFX;
    }

    public BlastChemical setRGB(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        return this;
    }

    public BlastChemical setConfuse() {
        this.isConfuse = true;
        return this;
    }

    public BlastChemical setPoison() {
        this.isPoisonous = true;
        return this;
    }

    public BlastChemical setContagious() {
        this.isContagious = true;
        this.isMutate = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        super.doPreExplode();
        if (!this.playShortSoundFX) {
            ICBMSounds.DEBILITATION.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
    }

    @Override
    public void doExplode() {
        float radius = this.getBlastRadius();
        this.generateGraphicEffect();
        this.generateAudioEffect();
        if (this.isContagious || this.isPoisonous || this.isConfuse) {
            AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)radius, this.location.y() - (double)radius, this.location.z() - (double)radius, this.location.x() + (double)radius, this.location.y() + (double)radius, this.location.z() + (double)radius);
            List allEntities = this.world().func_72872_a(EntityLivingBase.class, bounds);
            for (EntityLivingBase entity : allEntities) {
                if (this.isContagious) {
                    ICBMClassic.contagios_potion.poisonEntity(this.location.toPos(), entity);
                }
                if (this.isPoisonous) {
                    ICBMClassic.poisonous_potion.poisonEntity(this.location.toPos(), entity);
                }
                if (!this.isConfuse) continue;
                entity.func_70690_d((PotionEffect)new CustomPotionEffect(MobEffects.field_76436_u, 360, 0));
                entity.func_70690_d((PotionEffect)new CustomPotionEffect(MobEffects.field_76419_f, 1200, 0));
                entity.func_70690_d((PotionEffect)new CustomPotionEffect(MobEffects.field_76421_d, 1200, 2));
            }
        }
        if (this.isMutate) {
            new BlastMutation(this.world(), this.field_77283_e, this.location.x(), this.location.y(), this.location.z(), radius).runBlast();
        }
        if (this.callCount > this.duration) {
            this.controller.endExplosion();
        }
    }

    protected void generateAudioEffect() {
        if (this.playShortSoundFX) {
            ICBMSounds.GAS_LEAK.play(this.field_77287_j, this.location.x() + 0.5, this.location.y() + 0.5, this.location.z() + 0.5, 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
        }
    }

    protected void generateGraphicEffect() {
        if (this.world().field_72995_K) {
            float radius = this.getBlastRadius();
            for (int i = 0; i < 200; ++i) {
                Pos randomSpawnPoint = new Pos(Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f), Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f), Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f));
                if (!((randomSpawnPoint = (Pos)randomSpawnPoint.multiply(Math.min(radius, (float)this.callCount) / 10.0f)).magnitude() <= (double)radius)) continue;
                randomSpawnPoint = (Pos)randomSpawnPoint.add(this.location);
                ICBMClassic.proxy.spawnSmoke(this.field_77287_j, randomSpawnPoint, (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0, this.red, this.green, this.blue, 7.0f, 100);
            }
        }
    }

    @Override
    public int proceduralInterval() {
        return 5;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.duration = nbt.func_74762_e("duration");
        this.isContagious = nbt.func_74767_n("isContagious");
        this.isPoisonous = nbt.func_74767_n("isPoisonous");
        this.isConfuse = nbt.func_74767_n("isConfuse");
        this.isMutate = nbt.func_74767_n("isMutate");
        this.red = nbt.func_74760_g("red");
        this.green = nbt.func_74760_g("green");
        this.blue = nbt.func_74760_g("blue");
        this.playShortSoundFX = nbt.func_74767_n("playShortSoundFX");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74757_a("isContagious", this.isContagious);
        nbt.func_74757_a("isPoisonous", this.isPoisonous);
        nbt.func_74757_a("isConfuse", this.isConfuse);
        nbt.func_74757_a("isMutate", this.isMutate);
        nbt.func_74776_a("red", this.red);
        nbt.func_74776_a("green", this.green);
        nbt.func_74776_a("blue", this.blue);
        nbt.func_74757_a("playShortSoundFX", this.playShortSoundFX);
    }
}

