/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import com.mushroom.midnight.client.particle.AmbientSporeParticle;
import com.mushroom.midnight.client.particle.BombExplosionParticle;
import com.mushroom.midnight.client.particle.DripParticle;
import com.mushroom.midnight.client.particle.FadingSporeParticle;
import com.mushroom.midnight.client.particle.FurnaceFlameParticle;
import com.mushroom.midnight.client.particle.SporchParticle;
import com.mushroom.midnight.client.particle.SporeParticle;
import com.mushroom.midnight.client.particle.UnstableBushParticle;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum MidnightParticles {
    AMBIENT_SPORE,
    SPORE,
    DRIP,
    UNSTABLE_BUSH,
    SPORCH,
    FURNACE_FLAME,
    BOMB_EXPLOSION,
    FADING_SPORE;


    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Particle create(World world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, int ... parameters) {
        IParticleFactory factory = this.getFactory();
        return factory == null ? null : factory.func_178902_a(-1, world, x, y, z, velocityX, velocityY, velocityZ, parameters);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public IParticleFactory getFactory() {
        switch (this) {
            case AMBIENT_SPORE: {
                return new AmbientSporeParticle.Factory();
            }
            case SPORE: {
                return new SporeParticle.Factory();
            }
            case DRIP: {
                return new DripParticle.Factory();
            }
            case UNSTABLE_BUSH: {
                return new UnstableBushParticle.Factory();
            }
            case SPORCH: {
                return new SporchParticle.Factory();
            }
            case FURNACE_FLAME: {
                return new FurnaceFlameParticle.Factory();
            }
            case BOMB_EXPLOSION: {
                return new BombExplosionParticle.Factory();
            }
            case FADING_SPORE: {
                return new FadingSporeParticle.Factory();
            }
        }
        return null;
    }

    public void spawn(World world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, int ... parameters) {
        Particle particle;
        if (world.field_72995_K && (particle = this.create(world, x, y, z, velocityX, velocityY, velocityZ, parameters)) != null) {
            this.spawn(particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawn(Particle particle) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static MidnightParticles fromId(int id) {
        return MidnightParticles.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(MidnightParticles.values().length - 1))];
    }
}

