/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.render;

import com.mushroom.midnight.client.shader.ShaderHandle;
import com.mushroom.midnight.client.shader.WorldShader;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.entity.RiftBridge;
import com.mushroom.midnight.common.entity.RiftGeometry;
import javax.annotation.Nullable;
import javax.vecmath.Point2f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderRift
extends Render<EntityRift> {
    private static final double QUAD_WIDTH = 1.8;
    private static final double QUAD_HEIGHT = 2.6;
    private static final ResourceLocation RIFT_NOISE = new ResourceLocation("midnight", "textures/effects/rift_noise.png");
    private static final ResourceLocation RIFT_TEXTURE = new ResourceLocation("midnight", "textures/entities/rift.png");
    private final WorldShader shader = new WorldShader(new ResourceLocation("midnight", "rift")).withTextureSampler("NoiseSampler", RIFT_NOISE);

    public RenderRift(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityRift entity, double x, double y, double z, float entityYaw, float partialTicks) {
        RiftBridge bridge = entity.getBridge();
        if (bridge == null) {
            return;
        }
        float openProgress = bridge.getOpenAnimation(partialTicks);
        float unstableTime = bridge.getUnstableAnimation(partialTicks);
        if (openProgress > 0.0f) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)x, (double)(y + (double)(entity.field_70131_O / 2.0f)), (double)z);
            GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            float time = (float)entity.field_70173_aa + partialTicks;
            float openAnimation = this.computeOpenAnimation(openProgress);
            float unstableAnimation = this.computeUnstableAnimation(unstableTime);
            if (this.shader.isAvailable() && MidnightConfig.client.riftShaders) {
                this.renderShader(entity, time, openAnimation, unstableAnimation);
            } else {
                this.renderTexture(time, openAnimation, unstableAnimation);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
        }
    }

    private void renderShader(EntityRift entity, float time, float openAnimation, float unstableAnimation) {
        RiftGeometry geometry = entity.getGeometry();
        Point2f[] ring = geometry.computePath(openAnimation, unstableAnimation, time);
        GlStateManager.func_179147_l();
        try (ShaderHandle ignored = this.shader.use(shader -> {
            for (int i = 0; i < ring.length; ++i) {
                Point2f point = ring[i];
                shader.get("vertices[" + i + "]").func_148087_a(point.x, point.y);
            }
            shader.get("Time").func_148090_a(time);
        });){
            GlStateManager.func_179129_p();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            builder.func_181662_b(-1.8, 2.6, 0.0).func_181675_d();
            builder.func_181662_b(1.8, 2.6, 0.0).func_181675_d();
            builder.func_181662_b(1.8, -2.6, 0.0).func_181675_d();
            builder.func_181662_b(-1.8, -2.6, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_179084_k();
    }

    private void renderTexture(float time, float openAnimation, float unstableAnimation) {
        Minecraft client = Minecraft.func_71410_x();
        client.func_110434_K().func_110577_a(RIFT_TEXTURE);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        double width = 2.0;
        double height = 4.0;
        float idleSpeed = 0.08f;
        float idleIntensity = 0.1f * openAnimation * (unstableAnimation * 5.0f + 1.0f);
        float idleAnimation = (MathHelper.func_76126_a((float)(time * idleSpeed)) + 1.0f) * 0.4f * idleIntensity;
        GlStateManager.func_179152_a((float)openAnimation, (float)openAnimation, (float)1.0f);
        GlStateManager.func_179152_a((float)(1.0f + idleAnimation), (float)(1.0f + idleAnimation * 0.5f), (float)1.0f);
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(-width, height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        builder.func_181662_b(width, height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        builder.func_181662_b(width, -height, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b(-width, -height, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
    }

    private float computeOpenAnimation(float openProgress) {
        float openAnimation = openProgress / 20.0f;
        openAnimation = (float)(1.0 - Math.pow(1.0 - (double)openAnimation, 3.0));
        openAnimation = MathHelper.func_76131_a((float)openAnimation, (float)0.0f, (float)1.0f);
        return openAnimation;
    }

    private float computeUnstableAnimation(float unstableTime) {
        float unstableAnimation = unstableTime / 110.0f;
        unstableAnimation = (float)(1.0 - Math.pow(1.0 - (double)unstableAnimation, 2.0));
        unstableAnimation = MathHelper.func_76131_a((float)unstableAnimation, (float)0.0f, (float)1.0f);
        return unstableAnimation;
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityRift entity) {
        return null;
    }
}

