/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import java.util.Arrays;
import java.util.function.IntFunction;
import net.minecraft.world.World;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public interface BiomeLayerSampler<T> {
    public static <T> BiomeLayerSampler<T> fromGenLayer(World world, GenLayer noiseLayer, IntFunction<T> function, boolean undergroundLayer) {
        WorldInfo worldInfo = world.func_72912_H();
        long seed = worldInfo.func_76063_b();
        GenLayerVoronoiZoom layer = new GenLayerVoronoiZoom(10L, noiseLayer);
        layer.func_75905_a(seed);
        GenLayer[] layers = new GenLayer[]{noiseLayer, layer, noiseLayer};
        if (!undergroundLayer) {
            WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldInfo.func_76067_t(), seed, layers);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            return new Vanilla(event.getNewBiomeGens(), function);
        }
        return new Vanilla(layers, function);
    }

    public T[] sample(T[] var1, int var2, int var3, int var4, int var5);

    public T[] sampleNoise(T[] var1, int var2, int var3, int var4, int var5);

    public T sample(int var1, int var2);

    public static class Vanilla<T>
    implements BiomeLayerSampler<T> {
        private final GenLayer layer;
        private final GenLayer noiseLayer;
        private final IntFunction<T> function;

        private Vanilla(GenLayer[] layers, IntFunction<T> function) {
            this.layer = layers[1];
            this.noiseLayer = layers[0];
            this.function = function;
        }

        @Override
        public T[] sample(T[] array, int x, int y, int width, int height) {
            return this.sampleLayer(array, x, y, width, height, this.layer);
        }

        @Override
        public T[] sampleNoise(T[] array, int x, int y, int width, int height) {
            return this.sampleLayer(array, x, y, width, height, this.noiseLayer);
        }

        @Override
        public T sample(int x, int y) {
            IntCache.func_76446_a();
            int[] ints = this.layer.func_75904_a(x, y, 1, 1);
            return this.function.apply(ints[0]);
        }

        private T[] sampleLayer(T[] array, int x, int y, int width, int height, GenLayer layer) {
            if (array.length != width * height) {
                throw new IllegalArgumentException("Given input array of wrong dimensions!");
            }
            IntCache.func_76446_a();
            int[] ints = layer.func_75904_a(x, y, width, height);
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.function.apply(ints[i]);
            }
            return array;
        }
    }

    public static class Constant<T>
    implements BiomeLayerSampler<T> {
        private final T value;

        public Constant(T value) {
            this.value = value;
        }

        @Override
        public T[] sample(T[] array, int x, int y, int width, int height) {
            Arrays.fill(array, this.value);
            return array;
        }

        @Override
        public T[] sampleNoise(T[] array, int x, int y, int width, int height) {
            Arrays.fill(array, this.value);
            return array;
        }

        @Override
        public T sample(int x, int y) {
            return this.value;
        }
    }
}

