/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mushroom.midnight.common.block.BlockBladeshroom;
import com.mushroom.midnight.common.block.BlockPileOfEggs;
import com.mushroom.midnight.common.block.BlockUnstableBushBloomed;
import com.mushroom.midnight.common.block.GeneratablePlant;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.feature.BoulderFeature;
import com.mushroom.midnight.common.world.feature.CrystalClusterFeature;
import com.mushroom.midnight.common.world.feature.DarkWillowTreeFeature;
import com.mushroom.midnight.common.world.feature.DeadLogFeature;
import com.mushroom.midnight.common.world.feature.DeadTreeFeature;
import com.mushroom.midnight.common.world.feature.DoubleFungiFeature;
import com.mushroom.midnight.common.world.feature.DoublePlantFeature;
import com.mushroom.midnight.common.world.feature.FungiFeature;
import com.mushroom.midnight.common.world.feature.GourdFeature;
import com.mushroom.midnight.common.world.feature.HeapFeature;
import com.mushroom.midnight.common.world.feature.IMidnightFeature;
import com.mushroom.midnight.common.world.feature.LargeBogshroomFeature;
import com.mushroom.midnight.common.world.feature.LargeBulbFungusFeature;
import com.mushroom.midnight.common.world.feature.LargeFungiFeature;
import com.mushroom.midnight.common.world.feature.MidnightAbstractFeature;
import com.mushroom.midnight.common.world.feature.MossFeature;
import com.mushroom.midnight.common.world.feature.PlantFeature;
import com.mushroom.midnight.common.world.feature.ShadowrootTreeFeature;
import com.mushroom.midnight.common.world.feature.SpikeFeature;
import com.mushroom.midnight.common.world.template.ShelfAttachProcessor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MidnightBiomeFeatures {
    public static final IMidnightFeature SHADOWROOT_TREE_FEATURE = new ShadowrootTreeFeature();
    public static final IMidnightFeature DARK_WILLOW_TREE_FEATURE = new DarkWillowTreeFeature();
    public static final IMidnightFeature DEAD_TREE_FEATURE = new DeadTreeFeature(ShelfAttachProcessor.FOREST_SHELF_BLOCKS);
    public static final IMidnightFeature BOG_DEAD_TREE_FEATURE = new DeadTreeFeature(ShelfAttachProcessor.SHELF_BLOCKS);
    public static final IMidnightFeature DEAD_LOG_FEATURE = new DeadLogFeature();
    public static final IMidnightFeature TALL_GRASS_FEATURE = new PlantFeature(ModBlocks.TALL_MIDNIGHT_GRASS.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature DOUBLE_GRASS_FEATURE = new DoublePlantFeature(ModBlocks.DOUBLE_MIDNIGHT_GRASS.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature LUMEN_FEATURE = new PlantFeature(ModBlocks.LUMEN_BUD.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature BLADESHROOM_FEATURE = new PlantFeature(ModBlocks.BLADESHROOM.func_176223_P().func_177226_a(BlockBladeshroom.STAGE, (Comparable)((Object)BlockBladeshroom.Stage.CAPPED)), GeneratablePlant::canGenerate);
    public static final IMidnightFeature SUAVIS_FEATURE = new GourdFeature(ModBlocks.SUAVIS.func_176223_P(), ModBlocks.MIDNIGHT_GRASS, 2);
    public static final IMidnightFeature COMMON_SUAVIS_FEATURE = new GourdFeature(ModBlocks.SUAVIS.func_176223_P(), ModBlocks.MIDNIGHT_GRASS, 1);
    public static final IMidnightFeature DECEITFUL_ALGAE_FEATURE = new PlantFeature(ModBlocks.DECEITFUL_ALGAE.func_176223_P(), (world, pos, state) -> ModBlocks.DECEITFUL_ALGAE.func_176196_c(world, pos));
    public static final IMidnightFeature DECEITFUL_MOSS_FEATURE = new MossFeature(ModBlocks.DECEITFUL_MOSS.func_176223_P());
    public static final IMidnightFeature BOGWEED_FEATURE = new PlantFeature(ModBlocks.BOGWEED.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature GHOST_PLANT_FEATURE = new PlantFeature(ModBlocks.GHOST_PLANT.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature FINGERED_GRASS_FEATURE = new PlantFeature(ModBlocks.FINGERED_GRASS.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature VIOLEAF_FEATURE = new PlantFeature(ModBlocks.VIOLEAF.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature UNSTABLE_BUSH_FEATURE = new PlantFeature(ModBlocks.UNSTABLE_BUSH.func_176223_P(), GeneratablePlant::canGenerate){

        @Override
        public boolean placeFeature(World world, Random rand, BlockPos origin) {
            Block block = rand.nextInt(3) != 0 ? ModBlocks.UNSTABLE_BUSH_BLUE_BLOOMED : (rand.nextInt(3) != 0 ? ModBlocks.UNSTABLE_BUSH_LIME_BLOOMED : ModBlocks.UNSTABLE_BUSH_GREEN_BLOOMED);
            IBlockState state = block.func_176223_P().func_177226_a((IProperty)BlockUnstableBushBloomed.HAS_FRUIT, (Comparable)Boolean.valueOf(true));
            if (this.predicate.canSpawn(world, origin, state)) {
                this.func_175903_a(world, origin, state);
                return true;
            }
            return false;
        }
    };
    public static final IMidnightFeature RUNEBUSH_FEATURE = new PlantFeature(ModBlocks.RUNEBUSH.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature DOUBLE_LUMEN_FEATURE = new DoublePlantFeature(ModBlocks.DOUBLE_LUMEN_BUD.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature FUNGI_FEATURE = new FungiFeature(FungiFeature.FUNGI_STATES);
    public static final IMidnightFeature BOG_FUNGI_FEATURE = new FungiFeature(FungiFeature.BOG_FUNGI_STATES);
    public static final IMidnightFeature DOUBLE_FUNGI_FEATURE = new DoubleFungiFeature(DoubleFungiFeature.FUNGI_STATES);
    public static final IMidnightFeature DOUBLE_BOG_FUNGI_FEATURE = new DoubleFungiFeature(DoubleFungiFeature.BOG_FUNGI_STATES);
    public static final IMidnightFeature DRAGON_NEST_FEATURE = new PlantFeature(ModBlocks.DRAGON_NEST.func_176223_P(), (world, pos, state) -> ModBlocks.DRAGON_NEST.func_176196_c(world, pos));
    public static final IMidnightFeature CRYSTAL_FLOWER_FEATURE = new PlantFeature(ModBlocks.CRYSTAL_FLOWER.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature[] LARGE_FUNGI_FEATURES = new LargeFungiFeature[]{new LargeFungiFeature(ModBlocks.DEWSHROOM_STEM.func_176223_P(), ModBlocks.DEWSHROOM_HAT.func_176223_P()), new LargeFungiFeature(ModBlocks.NIGHTSHROOM_STEM.func_176223_P(), ModBlocks.NIGHTSHROOM_HAT.func_176223_P()), new LargeFungiFeature(ModBlocks.VIRIDSHROOM_STEM.func_176223_P(), ModBlocks.VIRIDSHROOM_HAT.func_176223_P())};
    public static final IMidnightFeature LARGE_BOGSHROOM_FEATURE = new LargeBogshroomFeature();
    public static final IMidnightFeature LARGE_BULB_FUNGUS_FEATURE = new LargeBulbFungusFeature();
    public static final IMidnightFeature BULB_FUNGUS_FEATURE = new PlantFeature(ModBlocks.BULB_FUNGUS.func_176223_P(), GeneratablePlant::canGenerate);
    public static final IMidnightFeature BLOOMCRYSTAL_FEATURE = new CrystalClusterFeature(3, 4, ModBlocks.BLOOMCRYSTAL_ROCK.func_176223_P(), ModBlocks.BLOOMCRYSTAL.func_176223_P());
    public static final IMidnightFeature BLOOMCRYSTAL_SPIRE_FEATURE = new CrystalClusterFeature(4, 13, ModBlocks.BLOOMCRYSTAL_ROCK.func_176223_P(), ModBlocks.BLOOMCRYSTAL.func_176223_P());
    public static final IMidnightFeature ROUXE_FEATURE = new CrystalClusterFeature(3, 4, ModBlocks.ROUXE_ROCK.func_176223_P(), ModBlocks.ROUXE.func_176223_P());
    public static final IMidnightFeature NIGHTSTONE_BOULDER_FEATURE = new BoulderFeature(2.0f){

        @Override
        protected IBlockState getStateForPlacement(World world, BlockPos origin, BlockPos pos, double dist, float radiusSquare, Random random) {
            return ModBlocks.NIGHTSTONE.func_176223_P();
        }
    };
    public static final IMidnightFeature NIGHTSTONE_SPIKE_FEATURE = new SpikeFeature(ModBlocks.NIGHTSTONE.func_176223_P());
    public static final IMidnightFeature TRENCHSTONE_BOULDER_FEATURE = new BoulderFeature(2.0f){
        private final float radiusSquareIn;
        {
            this.radiusSquareIn = this.radius <= 1.0f ? 0.0f : (this.radius - 1.0f) * (this.radius - 1.0f);
        }

        @Override
        protected IBlockState getStateForPlacement(World world, BlockPos origin, BlockPos pos, double dist, float radiusSquare, Random random) {
            return dist <= (double)this.radiusSquareIn && random.nextFloat() < 0.1f ? ModBlocks.ARCHAIC_ORE.func_176223_P() : ModBlocks.TRENCHSTONE.func_176223_P();
        }
    };
    public static final IMidnightFeature ROCKSHROOM_HEAP_FEATURE = new HeapFeature(ModBlocks.ROCKSHROOM.func_176223_P());
    public static final IMidnightFeature[] UNDERGROUND_FEATURES = new IMidnightFeature[]{new PlantFeature(ModBlocks.TENDRILWEED.func_176223_P(), GeneratablePlant::canGenerate), FUNGI_FEATURE, new MidnightAbstractFeature(){

        @Override
        public boolean placeFeature(World world, Random random, BlockPos origin) {
            if (world.func_180495_p(origin.func_177977_b()).func_185913_b()) {
                world.func_180501_a(origin, ModBlocks.STINGER_EGG.func_176223_P().func_177226_a((IProperty)BlockPileOfEggs.EGGS, (Comparable)Integer.valueOf(random.nextInt(4) + 1)), 18);
                return true;
            }
            return false;
        }
    }};
}

