/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome.config;

import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.registry.ModCavernousBiomes;
import com.mushroom.midnight.common.util.SessionLocal;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.IntPredicate;
import net.minecraft.world.biome.Biome;

public interface BiomeSpawnEntry {
    public int getBiomeId();

    public boolean canReplace(int var1);

    public int getWeight();

    public static class Basic
    implements BiomeSpawnEntry {
        private final SessionLocal<Integer> biomeId;
        private IntPredicate canReplace;
        private final int weight;

        public Basic(Biome biome, int weight) {
            this.biomeId = SessionLocal.register(() -> Biome.func_185362_a((Biome)biome));
            this.weight = weight;
        }

        public Basic(CavernousBiome biome, int weight) {
            this.biomeId = SessionLocal.register(() -> ModCavernousBiomes.getId(biome));
            this.weight = weight;
        }

        public Basic canReplace(IntPredicate predicate) {
            this.canReplace = predicate;
            return this;
        }

        public Basic canReplace(Biome ... biomes) {
            SessionLocal<IntSet> biomeIds = SessionLocal.register(() -> {
                IntOpenHashSet ids = new IntOpenHashSet();
                for (Biome biome : biomes) {
                    ids.add(Biome.func_185362_a((Biome)biome));
                }
                return ids;
            });
            this.canReplace = id -> ((IntSet)biomeIds.get()).contains(id);
            return this;
        }

        public Basic canReplace(CavernousBiome ... biomes) {
            SessionLocal<IntSet> biomeIds = SessionLocal.register(() -> {
                IntOpenHashSet ids = new IntOpenHashSet();
                for (CavernousBiome biome : biomes) {
                    ids.add(ModCavernousBiomes.getId(biome));
                }
                return ids;
            });
            this.canReplace = id -> ((IntSet)biomeIds.get()).contains(id);
            return this;
        }

        @Override
        public int getBiomeId() {
            return this.biomeId.get();
        }

        @Override
        public boolean canReplace(int biome) {
            if (this.canReplace == null) {
                return true;
            }
            return this.canReplace.test(biome);
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }
}

