/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mushroom.midnight.common.biome.MidnightBiomeDecorator;
import com.mushroom.midnight.common.biome.config.BiomeFeatureEntry;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import com.mushroom.midnight.common.world.feature.FeatureSorting;
import com.mushroom.midnight.common.world.feature.IMidnightFeature;
import com.mushroom.midnight.common.world.feature.config.IPlacementConfig;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.biome.Biome;

public class FeatureConfig {
    public static final FeatureConfig EMPTY = new FeatureConfig((ImmutableMultimap<FeatureSorting, BiomeFeatureEntry>)ImmutableMultimap.of(), (ImmutableList<Biome.FlowerEntry>)ImmutableList.of());
    private final ImmutableMultimap<FeatureSorting, BiomeFeatureEntry> features;
    private final ImmutableList<Biome.FlowerEntry> flowers;

    private FeatureConfig(ImmutableMultimap<FeatureSorting, BiomeFeatureEntry> features, ImmutableList<Biome.FlowerEntry> flowers) {
        this.features = features;
        this.flowers = flowers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<BiomeFeatureEntry> getFeatures(FeatureSorting pass) {
        return this.features.get((Object)pass);
    }

    public List<Biome.FlowerEntry> getFlowers() {
        return this.flowers;
    }

    public MidnightBiomeDecorator createDecorator(SurfacePlacementLevel placementLevel) {
        return new MidnightBiomeDecorator(this, placementLevel);
    }

    public static class Builder {
        private final ImmutableMultimap.Builder<FeatureSorting, BiomeFeatureEntry> features = new ImmutableMultimap.Builder();
        private final ImmutableList.Builder<Biome.FlowerEntry> flowers = new ImmutableList.Builder();

        Builder() {
        }

        public Builder extendsFrom(FeatureConfig config) {
            this.features.putAll((Multimap)config.features);
            this.flowers.addAll((Iterable)config.flowers);
            return this;
        }

        public Builder withFeature(IMidnightFeature feature, IPlacementConfig config) {
            return this.withFeature(FeatureSorting.NORMAL, feature, config);
        }

        public Builder withFeature(IMidnightFeature[] features, IPlacementConfig config) {
            return this.withFeature(FeatureSorting.NORMAL, features, config);
        }

        public Builder withFeature(FeatureSorting sorting, IMidnightFeature feature, IPlacementConfig config) {
            this.features.put((Object)sorting, (Object)new BiomeFeatureEntry(new IMidnightFeature[]{feature}, config));
            return this;
        }

        public Builder withFeature(FeatureSorting sorting, IMidnightFeature[] features, IPlacementConfig config) {
            this.features.put((Object)sorting, (Object)new BiomeFeatureEntry(features, config));
            return this;
        }

        public Builder withFlower(Biome.FlowerEntry ... flowers) {
            this.flowers.add((Object[])flowers);
            return this;
        }

        public FeatureConfig build() {
            return new FeatureConfig(this.features.build(), this.flowers.build());
        }
    }
}

