/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.block.BlockMidnightPlant;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.registry.ModItems;
import com.mushroom.midnight.common.util.MidnightDamageSource;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockBladeshroom
extends BlockMidnightPlant
implements IGrowable {
    public static final PropertyEnum<Stage> STAGE = PropertyEnum.func_177709_a((String)"stage", Stage.class);
    private static final int REGROW_CHANCE = 10;
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5625, 0.9375);
    private static final AxisAlignedBB STEM_BOUNDS = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final DamageSource BLADESHROOM_DAMAGE = new MidnightDamageSource("bladeshroom").func_76348_h().func_151518_m();

    public BlockBladeshroom() {
        super(false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(STAGE, (Comparable)((Object)Stage.SPORE)));
        this.func_149675_a(true);
        this.func_149647_a(null);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177229_b(STAGE) == Stage.CAPPED ? PathNodeType.DAMAGE_CACTUS : super.getAiPathNodeType(state, world, pos);
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return state.func_185898_k();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(STAGE) == Stage.CAPPED) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(ModItems.BLADESHROOM_CAP));
            world.func_175656_a(pos, state.func_177226_a(STAGE, (Comparable)((Object)Stage.STEM)));
            if (MidnightConfig.general.bladeshroomDamageChance != 0 && world.field_73012_v.nextInt(100) < MidnightConfig.general.bladeshroomDamageChance) {
                player.func_70097_a(BLADESHROOM_DAMAGE, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(STAGE) == Stage.CAPPED) {
            drops.add((Object)new ItemStack(ModItems.BLADESHROOM_CAP));
        }
        Random random = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        drops.add((Object)new ItemStack(ModItems.BLADESHROOM_SPORES, this.quantityDropped(state, fortune, random)));
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int quantity = 0;
        if (state.func_177229_b(STAGE) == Stage.CAPPED) {
            ++quantity;
        }
        if (random.nextInt(3) == 0) {
            ++quantity;
        }
        return quantity;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(STAGE) == Stage.CAPPED ? BOUNDS : STEM_BOUNDS;
    }

    @Override
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (state.func_177229_b(STAGE) == Stage.CAPPED) {
            entity.func_70097_a(BLADESHROOM_DAMAGE, 1.0f);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (random.nextInt(10) == 0) {
            this.incrementStage(world, pos, state);
        }
    }

    private void incrementStage(World world, BlockPos pos, IBlockState state) {
        Stage nextStage = ((Stage)((Object)state.func_177229_b(STAGE))).next();
        if (nextStage == null) {
            return;
        }
        world.func_175656_a(pos, state.func_177226_a(STAGE, (Comparable)((Object)nextStage)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public int func_176201_c(IBlockState state) {
        return ((Stage)((Object)state.func_177229_b(STAGE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(STAGE, (Comparable)((Object)Stage.deserialize(meta)));
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return state.func_177229_b(STAGE) != Stage.CAPPED;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.incrementStage(world, pos, state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModItems.BLADESHROOM_SPORES);
    }

    public static enum Stage implements IStringSerializable
    {
        SPORE,
        STEM,
        CAPPED;


        @Nullable
        public Stage next() {
            Stage[] stages = Stage.values();
            int ordinal = this.ordinal();
            if (ordinal < stages.length - 1) {
                return stages[ordinal + 1];
            }
            return null;
        }

        public static Stage deserialize(int meta) {
            Stage[] stages = Stage.values();
            return stages[meta % stages.length];
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

