/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.block.GeneratablePlant;
import com.mushroom.midnight.common.capability.CavernousBiomeStore;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModTabs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMidnightGrass
extends Block
implements IGrowable,
IModelProvider {
    public BlockMidnightGrass() {
        super(Material.field_151577_b, MapColor.field_193563_O);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149647_a(ModTabs.BUILDING_TAB);
        this.setHarvestLevel("shovel", 0);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || !world.func_175697_a(pos, 3)) {
            return;
        }
        BlockPos abovePos = pos.func_177984_a();
        if (!Helper.isMidnightDimension(world) || world.func_180495_p(abovePos).getLightOpacity((IBlockAccess)world, abovePos) > 2) {
            world.func_175656_a(pos, ModBlocks.MIDNIGHT_DIRT.func_176223_P());
            return;
        }
        for (int i = 0; i < 4; ++i) {
            IBlockState coverState;
            BlockPos spreadPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
            if (spreadPos.func_177956_o() >= 0 && spreadPos.func_177956_o() < 256 && !world.func_175667_e(spreadPos)) {
                return;
            }
            IBlockState surfaceState = world.func_180495_p(spreadPos);
            if (surfaceState.func_177230_c() != ModBlocks.MIDNIGHT_DIRT || (coverState = world.func_180495_p(spreadPos.func_177984_a())).getLightOpacity((IBlockAccess)world, spreadPos.func_177984_a()) > 2) continue;
            world.func_175656_a(spreadPos, this.func_176223_P());
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return true;
    }

    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        world.func_180501_a(pos, ModBlocks.MIDNIGHT_DIRT.func_176223_P(), 2);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.MIDNIGHT_DIRT);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos blockpos = pos.func_177984_a();
        boolean isMidnight = Helper.isMidnightDimension(worldIn);
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!Helper.isGroundForBoneMeal(worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c()) || worldIn.func_180495_p(blockpos1).func_185915_l()) continue block0;
            }
            if (!worldIn.func_175623_d(blockpos1)) continue;
            if (rand.nextInt(8) == 0) {
                if (isMidnight && blockpos1.func_177956_o() < 46) {
                    CavernousBiomeStore.getBiome(worldIn, blockpos1.func_177958_n(), blockpos1.func_177952_p()).plantFlower(worldIn, rand, blockpos1);
                    continue;
                }
                worldIn.func_180494_b(blockpos1).plantFlower(worldIn, rand, blockpos1);
                continue;
            }
            IBlockState tallGrassState = ModBlocks.TALL_MIDNIGHT_GRASS.func_176223_P();
            if (!GeneratablePlant.canGenerate(worldIn, blockpos1, tallGrassState)) continue;
            worldIn.func_180501_a(blockpos1, tallGrassState, 3);
        }
    }
}

