/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.capability;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.network.MessageAnimation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AnimationCapability
implements ICapabilityProvider {
    private AnimationType animationType = AnimationType.NONE;
    private int maxTicks;
    private int prevTick;
    private int currentTick;

    public void setAnimation(Entity animable, AnimationType animationType, int duration) {
        this.animationType = animationType;
        this.maxTicks = duration;
        this.currentTick = 0;
        if (!animable.field_70170_p.field_72995_K) {
            Midnight.NETWORK.sendToAllTracking((IMessage)new MessageAnimation(animable, animationType, duration), animable);
        }
    }

    public AnimationType getAnimationType() {
        return this.animationType;
    }

    public int getDuration() {
        return this.maxTicks;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public float getProgress(float partialTicks) {
        return ((float)this.prevTick + (float)(this.currentTick - this.prevTick) * partialTicks) / (float)this.maxTicks;
    }

    public void updateAnimation() {
        if (this.animationType != AnimationType.NONE) {
            this.prevTick = this.currentTick;
            if (this.currentTick >= this.maxTicks) {
                this.maxTicks = 0;
                this.currentTick = 0;
                this.animationType = AnimationType.NONE;
            } else {
                ++this.currentTick;
            }
        }
    }

    public void resetAnimation(Entity animable) {
        this.setAnimation(animable, AnimationType.NONE, 0);
    }

    public boolean isAnimate() {
        return this.animationType != AnimationType.NONE;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Midnight.ANIMATION_CAP;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Midnight.ANIMATION_CAP) {
            return (T)Midnight.ANIMATION_CAP.cast((Object)this);
        }
        return null;
    }

    public static enum AnimationType {
        NONE,
        ATTACK,
        EAT,
        CURTSEY,
        CHARGE;

    }
}

