/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.capability;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.biome.surface.SurfaceBiome;
import com.mushroom.midnight.common.capability.CavernousBiomeStore;
import com.mushroom.midnight.common.registry.ModSurfaceBiomes;
import com.mushroom.midnight.common.world.MidnightEntitySpawner;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface MidnightWorldSpawners
extends ICapabilityProvider {
    public void populateChunk(int var1, int var2, Random var3);

    public void spawnAroundPlayers();

    default public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Midnight.WORLD_SPAWNERS_CAP;
    }

    @Nullable
    default public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Midnight.WORLD_SPAWNERS_CAP) {
            return (T)Midnight.WORLD_SPAWNERS_CAP.cast((Object)this);
        }
        return null;
    }

    public static class SurfaceAndCave
    implements MidnightWorldSpawners {
        private final WorldServer world;
        private final MidnightEntitySpawner<SurfaceBiome> biomeEntitySpawner;
        private final MidnightEntitySpawner<CavernousBiome> cavernEntitySpawner;

        public SurfaceAndCave(WorldServer world) {
            this.world = world;
            this.biomeEntitySpawner = new MidnightEntitySpawner<SurfaceBiome>(this::getSurfaceSpawnBiome, SurfaceBiome.PlacementLevel.INSTANCE);
            this.cavernEntitySpawner = new MidnightEntitySpawner<CavernousBiome>(this::getCavernSpawnBiome, CavernousBiome.PlacementLevel.INSTANCE);
        }

        private SurfaceBiome getSurfaceSpawnBiome(BlockPos pos) {
            Biome biome = this.world.func_180494_b(pos);
            if (biome instanceof SurfaceBiome) {
                return (SurfaceBiome)biome;
            }
            return (SurfaceBiome)ModSurfaceBiomes.NIGHT_PLAINS;
        }

        private CavernousBiome getCavernSpawnBiome(BlockPos pos) {
            return CavernousBiomeStore.getBiome((World)this.world, pos.func_177958_n(), pos.func_177952_p());
        }

        @Override
        public void populateChunk(int chunkX, int chunkZ, Random random) {
            this.biomeEntitySpawner.populateChunk((World)this.world, chunkX, chunkZ, random);
            this.cavernEntitySpawner.populateChunk((World)this.world, chunkX, chunkZ, random);
        }

        @Override
        public void spawnAroundPlayers() {
            this.biomeEntitySpawner.spawnAroundPlayers(this.world);
            this.cavernEntitySpawner.spawnAroundPlayers(this.world);
        }
    }

    public static class Void
    implements MidnightWorldSpawners {
        @Override
        public void populateChunk(int chunkX, int chunkZ, Random random) {
        }

        @Override
        public void spawnAroundPlayers() {
        }
    }
}

