/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.block.BlockUnstableBush;
import com.mushroom.midnight.common.block.BlockUnstableBushBloomed;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.entity.navigation.CustomPathNavigateGround;
import com.mushroom.midnight.common.entity.task.EntityTaskCharge;
import com.mushroom.midnight.common.entity.task.EntityTaskEatGrass;
import com.mushroom.midnight.common.entity.task.EntityTaskNeutral;
import com.mushroom.midnight.common.entity.task.EntityTaskSearchBlock;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.item.ItemUnstableFruit;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModCriterion;
import com.mushroom.midnight.common.registry.ModEffects;
import com.mushroom.midnight.common.registry.ModLootTables;
import com.mushroom.midnight.common.registry.ModSounds;
import com.mushroom.midnight.common.registry.ModSurfaceBiomes;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;

public class EntityNightStag
extends EntityAnimal {
    private static final DataParameter<Integer> ANTLER_TYPE = EntityDataManager.func_187226_a(EntityNightStag.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final int MAX_ANTLER_TYPE = 9;
    private static final AttributeModifier CHILD_ATTACK_MALUS = new AttributeModifier(UUID.fromString("c0f32cda-a4fd-4fe4-8b3f-15612ef9a52f"), "nightstag_child_attack_malus", -2.0, 0);
    private static final int GROWING_TIME = -24000;
    private static final Predicate<IBlockState> FRUIT_PREDICATE = p -> p.func_177230_c() instanceof BlockUnstableBushBloomed && (Boolean)p.func_177229_b((IProperty)BlockUnstableBushBloomed.HAS_FRUIT) != false;
    private final AnimationCapability animCap = new AnimationCapability();
    private int temptTime = 400;

    public EntityNightStag(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.87f);
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable entity) {
        EntityNightStag child = new EntityNightStag(this.field_70170_p);
        child.func_70873_a(-24000);
        child.setAntlerType(((EntityNightStag)entity).getAntlerType());
        return child;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        if (Helper.isMidnightDimension(this.field_70170_p)) {
            Biome biome = this.field_70170_p.func_180494_b(this.func_180425_c());
            int random = this.field_70146_Z.nextInt(3);
            if (biome == ModSurfaceBiomes.VIGILANT_FOREST || biome == ModSurfaceBiomes.HILLY_VIGILANT_FOREST) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 3 : 7));
            } else if (biome == ModSurfaceBiomes.NIGHT_PLAINS || biome == ModSurfaceBiomes.WARPED_FIELDS) {
                this.setAntlerType(random == 0 ? 0 : 1);
            } else if (biome == ModSurfaceBiomes.RUNEBUSH_GROVE) {
                this.setAntlerType(random == 0 ? 3 : 8);
            } else if (biome == ModSurfaceBiomes.DECEITFUL_BOG) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 2 : 4));
            } else if (biome == ModSurfaceBiomes.FUNGI_FOREST || biome == ModSurfaceBiomes.HILLY_FUNGI_FOREST) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 2 : 3));
            } else if (biome == ModSurfaceBiomes.CRYSTAL_SPIRES) {
                this.setAntlerType(random == 0 ? 5 : 6);
            } else if (biome == ModSurfaceBiomes.PHANTASMAL_VALLEY || biome == ModSurfaceBiomes.OBSCURED_PEAKS || biome == ModSurfaceBiomes.OBSCURED_PLATEAU || biome == ModSurfaceBiomes.BLACK_RIDGE) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 5 : 7));
            } else {
                this.setAntlerType(this.field_70146_Z.nextInt(9));
            }
        } else {
            this.setAntlerType(this.field_70146_Z.nextInt(9));
        }
        return livingdata;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANTLER_TYPE, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("antler_type", this.getAntlerType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("antler_type", 3)) {
            int antlerType = compound.func_74762_e("antler_type");
            this.setAntlerType(antlerType >= 0 && antlerType < 9 ? antlerType : 0);
        }
    }

    public void setAntlerType(int antlerType) {
        this.field_70180_af.func_187227_b(ANTLER_TYPE, (Object)(antlerType >= 0 && antlerType < 9 ? antlerType : 0));
    }

    public int getAntlerType() {
        return (Integer)this.field_70180_af.func_187225_a(ANTLER_TYPE);
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.NIGHTSTAG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.NIGHTSTAG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.NIGHTSTAG_DEATH;
    }

    public int func_70627_aG() {
        return 200;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_191256_dG, 0.15f, 1.0f);
    }

    public float func_180484_a(BlockPos pos) {
        Block belowBlock = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
        return belowBlock == ModBlocks.MIDNIGHT_GRASS || belowBlock == ModBlocks.NIGHTSTONE ? 10.0f : 9.0f - this.field_70170_p.func_175724_o(pos) * 10.0f;
    }

    public boolean func_70601_bi() {
        if (this.func_180425_c().func_177956_o() <= this.field_70170_p.func_181545_F()) {
            return false;
        }
        IBlockState belowState = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return belowState.func_185917_h() && belowState.func_189884_a((Entity)this);
    }

    protected PathNavigate func_175447_b(World world) {
        return new CustomPathNavigateGround((EntityLiving)this, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral((EntityCreature)this, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2), true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral((EntityCreature)this, new EntityTaskCharge((EntityLiving)this, 1.2, 200, 0.25f), false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityTaskNeutral((EntityCreature)this, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false), false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_190931_a, false){

            protected boolean func_188508_a(ItemStack stack) {
                return EntityNightStag.this.func_70877_b(stack);
            }

            public boolean func_75250_a() {
                boolean valid = super.func_75250_a();
                if (valid && !this.field_75289_h.func_184812_l_() && --EntityNightStag.this.temptTime < 0) {
                    EntityNightStag.this.temptTime = 400;
                    EntityNightStag.this.func_70624_b((EntityLivingBase)this.field_75289_h);
                }
                return valid;
            }
        });
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityTaskSearchBlock((EntityCreature)this, FRUIT_PREDICATE, 0.7, 8, 200));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityTaskEatGrass((EntityLiving)this, 40, false, FRUIT_PREDICATE){

            @Override
            public boolean func_75250_a() {
                BlockPos currentPos;
                return super.func_75250_a() || (currentPos = EntityNightStag.this.func_180425_c()).equals((Object)EntityNightStag.this.func_180486_cf()) && FRUIT_PREDICATE.test(EntityNightStag.this.field_70170_p.func_180495_p(currentPos));
            }

            @Override
            protected void eatPlant(IBlockState state, BlockPos pos) {
                this.owner.field_70170_p.func_180501_a(pos, ModBlocks.UNSTABLE_BUSH.func_176223_P().func_177226_a((IProperty)BlockUnstableBush.STAGE, (Comparable)Integer.valueOf(4)), 2);
                if (EntityNightStag.this.func_70631_g_()) {
                    EntityNightStag.this.func_70873_a(Math.min(EntityNightStag.this.func_70874_b() + 5000, 0));
                }
                EntityNightStag.this.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200, 0, false, true));
                EntityNightStag.this.func_70690_d(new PotionEffect(ModEffects.UNSTABLE_FALL, 400, 0, false, true));
            }
        });
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.7, 0.005f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityTaskCurtsey((EntityLiving)this, EntityPlayer.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral((EntityCreature)this, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]), false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
    }

    protected void func_175500_n() {
        IAttributeInstance attackAttrib = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (attackAttrib.func_180374_a(CHILD_ATTACK_MALUS)) {
            attackAttrib.func_111124_b(CHILD_ATTACK_MALUS);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_70606_j(20.0f);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        super.func_70652_k(entity);
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.animCap.getAnimationType() == AnimationCapability.AnimationType.CHARGE) {
            damage *= 2.0f;
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            if (!this.func_70631_g_() && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(ModEffects.DARKNESS, 200, 0, false, true));
            }
            this.func_174815_a((EntityLivingBase)this, entity);
            this.animCap.setAnimation((Entity)this, AnimationCapability.AnimationType.ATTACK, 10);
        }
        return flag;
    }

    public void func_184609_a(EnumHand hand) {
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * 0.2f);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.67;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemUnstableFruit;
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        if (this.func_70877_b(stack)) {
            this.temptTime = 400;
            this.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200, 0, false, true));
            this.func_70690_d(new PotionEffect(ModEffects.UNSTABLE_FALL, 400, 0, false, true));
        }
        super.func_175505_a(player, stack);
    }

    public void func_70615_aA() {
        this.func_70691_i(1.0f);
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.func_70631_g_() ? 4 : 7;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.LOOT_TABLE_NIGHTSTAG;
    }

    public void func_70636_d() {
        IAttributeInstance attackAttrib;
        super.func_70636_d();
        this.animCap.updateAnimation();
        if (!this.field_70170_p.field_72995_K && this.func_70631_g_() && !(attackAttrib = this.func_110148_a(SharedMonsterAttributes.field_111264_e)).func_180374_a(CHILD_ATTACK_MALUS)) {
            attackAttrib.func_111121_a(CHILD_ATTACK_MALUS);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            this.func_70606_j(10.0f);
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Midnight.ANIMATION_CAP) {
            return (T)Midnight.ANIMATION_CAP.cast((Object)this.animCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Midnight.ANIMATION_CAP || super.hasCapability(capability, facing);
    }

    public class EntityTaskCurtsey
    extends EntityAIWatchClosest {
        EntityTaskCurtsey(EntityLiving entity, Class<? extends Entity> watchTargetClass, float maxDistance, float chance) {
            super(entity, watchTargetClass, maxDistance, chance);
            this.func_75248_a(3);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (!EntityNightStag.this.func_70631_g_() && EntityNightStag.this.func_70638_az() == null && EntityNightStag.this.func_70681_au().nextFloat() < 0.1f) {
                if (this.field_75334_a instanceof EntityPlayerMP && Helper.isNotFakePlayer(this.field_75334_a)) {
                    ModCriterion.NIGHTSTAG_BOW[EntityNightStag.this.getAntlerType()].trigger((EntityPlayerMP)this.field_75334_a);
                }
                EntityNightStag.this.animCap.setAnimation((Entity)this.field_75332_b, AnimationCapability.AnimationType.CURTSEY, 40);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            if (EntityNightStag.this.animCap.isAnimate()) {
                EntityNightStag.this.animCap.resetAnimation((Entity)this.field_75332_b);
            }
        }
    }
}

