/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.projectile;

import com.mushroom.midnight.common.item.ItemSporeBomb;
import com.mushroom.midnight.common.registry.ModItems;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySporeBomb
extends EntityThrowable {
    private static final DataParameter<ItemStack> BOMB_STACK = EntityDataManager.func_187226_a(EntitySporeBomb.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntitySporeBomb(World world) {
        super(world);
    }

    public EntitySporeBomb(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntitySporeBomb(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOMB_STACK, (Object)new ItemStack(ModItems.SPORE_BOMB));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("bomb_stack", (NBTBase)this.getBombStack().func_77955_b(new NBTTagCompound()));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("bomb_stack", 10)) {
            this.setBombStack(new ItemStack(compound.func_74775_l("bomb_stack")));
        }
    }

    public ItemStack getBombStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(BOMB_STACK);
    }

    public void setBombStack(ItemStack bombStack) {
        this.field_70180_af.func_187227_b(BOMB_STACK, (Object)bombStack);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getBombStack().func_82833_r();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                this.func_70099_a(new ItemStack(ModItems.DARK_PEARL), 0.1f);
                this.func_70106_y();
            } else if (ItemSporeBomb.checkExplode(this.field_70170_p, this.getBombStack())) {
                ItemSporeBomb.explode(ItemSporeBomb.BombType.fromStack(this.getBombStack()), this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70106_y();
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            DamageSource source = DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h());
            result.field_72308_g.func_70097_a(source, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.canBreakOn(result.func_178782_a())) {
                ItemSporeBomb.explode(ItemSporeBomb.BombType.fromStack(this.getBombStack()), this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            } else {
                this.func_70099_a(this.getBombStack().func_77946_l(), 0.01f);
            }
            this.func_70106_y();
        }
    }

    private boolean canBreakOn(@Nullable BlockPos impactedPos) {
        IBlockState impactedState;
        return impactedPos != null && ((impactedState = this.field_70170_p.func_180495_p(impactedPos)).func_185904_a() == Material.field_151576_e || impactedState.func_185904_a() == Material.field_151573_f);
    }
}

