/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import com.mushroom.midnight.common.entity.creature.EntityHunter;
import com.mushroom.midnight.common.entity.util.FlyingTargetGenerator;
import com.mushroom.midnight.common.entity.util.IRandomTargetGenerator;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;

public class EntityTaskHunterSwoop
extends EntityAIBase {
    private static final int SWOOP_COOLDOWN = 160;
    private static final int MAX_SWOOP_TICKS = 120;
    private static final int ATTACK_OFFSET_Y = 1;
    private final EntityHunter owner;
    private final double speed;
    private final IRandomTargetGenerator riseTargetGenerator;
    private int ticks;
    private boolean rising;

    public EntityTaskHunterSwoop(EntityHunter owner, double speed) {
        this.owner = owner;
        this.speed = speed;
        this.riseTargetGenerator = new FlyingTargetGenerator((EntityCreature)owner, 6, 10, 12, 14);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.owner.func_70638_az();
        return target != null && target.func_70089_S() && this.owner.swoopCooldown <= 0;
    }

    public boolean func_75253_b() {
        if (!this.func_75250_a()) {
            return false;
        }
        Path path = this.owner.func_70661_as().func_75505_d();
        return path != null && (!this.rising || !path.func_75879_b()) && this.ticks < 120;
    }

    public void func_75249_e() {
        EntityLivingBase target = this.owner.func_70638_az();
        if (target == null) {
            return;
        }
        this.recalculatePath(target);
    }

    public void func_75246_d() {
        EntityLivingBase target = this.owner.func_70638_az();
        if (target == null) {
            return;
        }
        if (this.ticks++ % 10 == 0) {
            this.recalculatePath(target);
        }
        if (this.canAttack(target)) {
            this.owner.func_70652_k((Entity)target);
            this.rising = true;
            this.recalculatePath(target);
        }
    }

    private void recalculatePath(EntityLivingBase target) {
        this.owner.func_70661_as().func_75499_g();
        Path path = this.produceTargetPath(target);
        if (path == null) {
            this.owner.func_70624_b(null);
        }
        this.owner.func_70661_as().func_75484_a(path, this.speed);
    }

    @Nullable
    private Path produceTargetPath(EntityLivingBase target) {
        if (this.rising) {
            for (int i = 0; i < 16; ++i) {
                Path path = this.produceRisePath(target);
                if (path == null) continue;
                return path;
            }
            return null;
        }
        return this.owner.func_70661_as().func_179680_a(target.func_180425_c().func_177981_b(1));
    }

    @Nullable
    private Path produceRisePath(EntityLivingBase target) {
        BlockPos flightPos = this.riseTargetGenerator.generate(target.func_180425_c());
        if (flightPos == null) {
            return null;
        }
        return this.owner.func_70661_as().func_179680_a(flightPos);
    }

    public void func_75251_c() {
        this.owner.func_70661_as().func_75499_g();
        this.owner.swoopCooldown = 160;
        this.rising = false;
        this.ticks = 0;
    }

    private boolean canAttack(EntityLivingBase target) {
        double attackReach;
        double distanceSq = target.func_174818_b(this.owner.func_180425_c().func_177979_c(1));
        return distanceSq < (attackReach = this.getAttackReach(target)) * attackReach;
    }

    private double getAttackReach(EntityLivingBase target) {
        double meanWidth = (2.0 + (double)target.field_70130_N) / 2.0;
        return meanWidth + 0.5;
    }
}

