/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import com.mushroom.midnight.common.entity.creature.EntityRifter;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;

public abstract class EntityTaskRifterFollow
extends EntityAIBase {
    protected final EntityRifter owner;
    protected final double followSpeed;
    protected BlockPos lastSeenPos;
    protected Path path;
    protected int invalidCounter;
    protected boolean navigatingFromMemory;

    public EntityTaskRifterFollow(EntityRifter owner, double followSpeed) {
        this.owner = owner;
        this.followSpeed = followSpeed;
        this.func_75248_a(3);
    }

    protected abstract void handleInteract(EntityLivingBase var1);

    public boolean func_75250_a() {
        EntityLivingBase target = this.owner.func_70638_az();
        if (this.shouldFollow(target)) {
            this.path = this.owner.func_70661_as().func_75494_a((Entity)target);
            return this.path != null;
        }
        return false;
    }

    public void func_75249_e() {
        this.owner.func_70661_as().func_75484_a(this.path, this.followSpeed);
    }

    public void func_75246_d() {
        Path targetPath;
        EntityLivingBase target = this.owner.func_70638_az();
        if (target == null) {
            return;
        }
        if (!this.navigatingFromMemory) {
            this.owner.func_70671_ap().func_75651_a((Entity)target, 20.0f, 20.0f);
        }
        if ((targetPath = this.computeFollowPath(target)) == null) {
            this.owner.func_70624_b(null);
            return;
        }
        Path currentPath = this.owner.func_70661_as().func_75505_d();
        if (currentPath != targetPath) {
            this.owner.func_70661_as().func_75484_a(targetPath, this.followSpeed);
        }
        if (this.canInteract(target)) {
            this.handleInteract(target);
        }
    }

    @Nullable
    protected Path computeFollowPath(EntityLivingBase target) {
        double followRange;
        double distanceSq;
        if (this.path.func_75879_b()) {
            this.path = null;
        }
        if ((distanceSq = this.owner.func_70068_e((Entity)target)) < (followRange = this.owner.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) * followRange) {
            this.updateFollowVisible(target);
        } else if (!this.navigatingFromMemory && this.lastSeenPos != null) {
            this.owner.func_70661_as().func_75499_g();
            this.path = this.owner.func_70661_as().func_179680_a(this.lastSeenPos);
            this.navigatingFromMemory = true;
        }
        return this.path;
    }

    protected void updateFollowVisible(EntityLivingBase target) {
        if (this.shouldInvalidatePath(target) || this.navigatingFromMemory) {
            this.invalidCounter = 0;
            this.owner.func_70661_as().func_75499_g();
            this.path = this.owner.func_70661_as().func_75494_a((Entity)target);
            if (this.path != null) {
                this.lastSeenPos = target.func_180425_c();
                this.navigatingFromMemory = false;
            } else {
                this.navigatingFromMemory = true;
            }
        }
    }

    protected boolean shouldInvalidatePath(EntityLivingBase target) {
        int invalidateTime = this.getPathInvalidateTime(target);
        return ++this.invalidCounter > invalidateTime;
    }

    protected int getPathInvalidateTime(EntityLivingBase target) {
        double distanceSq = this.owner.func_70068_e((Entity)target);
        if (distanceSq < 16.0) {
            return 5;
        }
        if (distanceSq < 64.0) {
            return 10;
        }
        return 20;
    }

    protected boolean canInteract(EntityLivingBase target) {
        double interactReach;
        double distanceSq = this.owner.func_70068_e((Entity)target);
        return distanceSq < (interactReach = this.getInteractReach(target)) * interactReach;
    }

    protected double getInteractReach(EntityLivingBase target) {
        double averageWidth = (double)(this.owner.field_70130_N + target.field_70130_N) / 2.0;
        return averageWidth + 0.5;
    }

    public boolean func_75253_b() {
        return this.path != null && this.shouldFollow(this.owner.func_70638_az());
    }

    public void func_75251_c() {
        this.owner.func_70661_as().func_75499_g();
        this.path = null;
        this.lastSeenPos = null;
        this.navigatingFromMemory = false;
        if (!this.shouldFollow(this.owner.func_70638_az())) {
            this.owner.func_70624_b(null);
        }
    }

    protected boolean shouldFollow(EntityLivingBase target) {
        EntityPlayer player;
        if (target == null) {
            return false;
        }
        if (target instanceof EntityPlayer && ((player = (EntityPlayer)target).func_175149_v() || player.func_184812_l_())) {
            return false;
        }
        return target.func_70089_S();
    }
}

