/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import net.minecraft.nbt.NBTTagCompound;

public class ToggleAnimation {
    private final int length;
    private int rate = 1;
    private boolean state;
    private int timer;

    public ToggleAnimation(int length) {
        this.length = length;
    }

    public void update() {
        this.timer = this.state ? Math.min(this.timer + this.rate, this.length) : Math.max(this.timer - this.rate, 0);
    }

    public void set(boolean state) {
        this.state = state;
    }

    public boolean get() {
        return this.state;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public int getTimer() {
        return this.timer;
    }

    public float getScale() {
        return (float)this.timer / (float)this.length;
    }

    public NBTTagCompound serialize(NBTTagCompound compound) {
        compound.func_74757_a("state", this.state);
        compound.func_74777_a("timer", (short)this.timer);
        compound.func_74774_a("rate", (byte)this.rate);
        return compound;
    }

    public void deserialize(NBTTagCompound compound) {
        this.state = compound.func_74767_n("state");
        this.timer = compound.func_74765_d("timer");
        this.rate = compound.func_74771_c("rate");
    }

    public String toString() {
        return "ToggleAnimation{state=" + this.state + ", timer=" + this.timer + '}';
    }
}

