/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.item;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.registry.ModTabs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMidnightDoor
extends ItemBlock
implements IModelProvider {
    public ItemMidnightDoor(Block block) {
        super(block);
        this.func_77637_a(ModTabs.DECORATION_TAB);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        Block currentBlock = world.func_180495_p(pos).func_177230_c();
        if (!currentBlock.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (player.func_175151_a(pos, facing, heldItem = player.func_184586_b(hand)) && this.field_150939_a.func_176196_c(world, pos)) {
            EnumFacing direction = EnumFacing.func_176733_a((double)player.field_70177_z);
            int xOffset = direction.func_82601_c();
            int zOffset = direction.func_82599_e();
            boolean rightHinge = xOffset < 0 && hitZ < 0.5f || xOffset > 0 && hitZ > 0.5f || zOffset < 0 && hitX > 0.5f || zOffset > 0 && hitX < 0.5f;
            this.placeDoor(world, pos, direction, this.field_150939_a, rightHinge);
            this.applyPlaceEffect(player, world, pos, heldItem);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private void placeDoor(World world, BlockPos pos, EnumFacing facing, Block door, boolean rightHinge) {
        BlockDoor.EnumHingePosition hinge = this.computeHinge(world, pos, facing, rightHinge);
        BlockPos upperPos = pos.func_177984_a();
        boolean powered = world.func_175640_z(pos) || world.func_175640_z(upperPos);
        IBlockState placeState = door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)hinge).func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)Boolean.valueOf(powered)).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(powered));
        world.func_180501_a(pos, placeState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER), 2);
        world.func_180501_a(upperPos, placeState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 2);
        world.func_175685_c(pos, door, false);
        world.func_175685_c(upperPos, door, false);
    }

    private BlockDoor.EnumHingePosition computeHinge(World world, BlockPos pos, EnumFacing facing, boolean rightHinge) {
        boolean doorRight;
        BlockPos posRight = pos.func_177972_a(facing.func_176746_e());
        BlockPos posLeft = pos.func_177972_a(facing.func_176735_f());
        int leftWeight = (world.func_180495_p(posLeft).func_185915_l() ? 1 : 0) + (world.func_180495_p(posLeft.func_177984_a()).func_185915_l() ? 1 : 0);
        int rightWeight = (world.func_180495_p(posRight).func_185915_l() ? 1 : 0) + (world.func_180495_p(posRight.func_177984_a()).func_185915_l() ? 1 : 0);
        boolean doorLeft = this.isDoor(world, posLeft) || this.isDoor(world, posLeft.func_177984_a());
        boolean bl = doorRight = this.isDoor(world, posRight) || this.isDoor(world, posRight.func_177984_a());
        if ((!doorLeft || doorRight) && rightWeight <= leftWeight) {
            if (doorRight && !doorLeft || rightWeight < leftWeight) {
                return BlockDoor.EnumHingePosition.LEFT;
            }
        } else {
            return BlockDoor.EnumHingePosition.RIGHT;
        }
        return rightHinge ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT;
    }

    private void applyPlaceEffect(EntityPlayer player, World world, BlockPos pos, ItemStack heldItem) {
        IBlockState state = world.func_180495_p(pos);
        SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        heldItem.func_190918_g(1);
    }

    private boolean isDoor(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockDoor;
    }
}

